package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies a set of Groups whose Users are to be included or excluded
 */
@ApiModel(description = "Specifies a set of Groups whose Users are to be included or excluded")
@JsonPropertyOrder({ GroupCondition.JSON_PROPERTY_EXCLUDE, GroupCondition.JSON_PROPERTY_INCLUDE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class GroupCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<String> exclude = new ArrayList<>();

    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<String> include = new ArrayList<>();

    public GroupCondition() {
    }

    public GroupCondition exclude(List<String> exclude) {

        this.exclude = exclude;
        return this;
    }

    public GroupCondition addexcludeItem(String excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    /**
     * Groups to be excluded
     *
     * @return exclude
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Groups to be excluded")
    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<String> getExclude() {
        return exclude;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    public GroupCondition include(List<String> include) {

        this.include = include;
        return this;
    }

    public GroupCondition addincludeItem(String includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<>();
        }
        this.include.add(includeItem);
        return this;
    }

    /**
     * Groups to be included
     *
     * @return include
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "Groups to be included")
    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public List<String> getInclude() {
        return include;
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setInclude(List<String> include) {
        this.include = include;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupCondition groupCondition = (GroupCondition) o;
        return Objects.equals(this.exclude, groupCondition.exclude)
                && Objects.equals(this.include, groupCondition.include);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(exclude, include);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupCondition {\n");
        sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
        sb.append("    include: ").append(toIndentedString(include)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
