package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.FulfillmentData;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Fulfillment Request
 */
@ApiModel(description = "Fulfillment Request")
@JsonPropertyOrder({ FulfillmentRequest.JSON_PROPERTY_FULFILLMENT_DATA,
        FulfillmentRequest.JSON_PROPERTY_FULFILLMENT_PROVIDER, FulfillmentRequest.JSON_PROPERTY_USER_ID })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class FulfillmentRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FULFILLMENT_DATA = "fulfillmentData";
    private FulfillmentData fulfillmentData;

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     */
    public enum FulfillmentProviderEnum {
        YUBICO(String.valueOf("yubico")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public FulfillmentRequest() {
    }

    public FulfillmentRequest fulfillmentData(FulfillmentData fulfillmentData) {

        this.fulfillmentData = fulfillmentData;
        return this;
    }

    /**
     * Get fulfillmentData
     *
     * @return fulfillmentData
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FULFILLMENT_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FulfillmentData getFulfillmentData() {
        return fulfillmentData;
    }

    @JsonProperty(JSON_PROPERTY_FULFILLMENT_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentData(FulfillmentData fulfillmentData) {
        this.fulfillmentData = fulfillmentData;
    }

    public FulfillmentRequest fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {

        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    /**
     * Name of the fulfillment provider for the WebAuthn Preregistration Factor
     *
     * @return fulfillmentProvider
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FulfillmentProviderEnum getFulfillmentProvider() {
        return fulfillmentProvider;
    }

    @JsonProperty(JSON_PROPERTY_FULFILLMENT_PROVIDER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public FulfillmentRequest userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * ID of an existing Okta user
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of an existing Okta user")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        FulfillmentRequest fulfillmentRequest = (FulfillmentRequest) o;
        return Objects.equals(this.fulfillmentData, fulfillmentRequest.fulfillmentData)
                && Objects.equals(this.fulfillmentProvider, fulfillmentRequest.fulfillmentProvider)
                && Objects.equals(this.userId, fulfillmentRequest.userId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(fulfillmentData, fulfillmentProvider, userId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentRequest {\n");
        sb.append("    fulfillmentData: ").append(toIndentedString(fulfillmentData)).append("\n");
        sb.append("    fulfillmentProvider: ").append(toIndentedString(fulfillmentProvider)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
