package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.EnhancedDynamicNetworkZoneAllOfAsns;
import com.okta.sdk.resource.model.EnhancedDynamicNetworkZoneAllOfIpServiceCategories;
import com.okta.sdk.resource.model.EnhancedDynamicNetworkZoneAllOfLocations;
import com.okta.sdk.resource.model.LinksSelfAndLifecycle;
import com.okta.sdk.resource.model.NetworkZone;
import com.okta.sdk.resource.model.NetworkZoneStatus;
import com.okta.sdk.resource.model.NetworkZoneType;
import com.okta.sdk.resource.model.NetworkZoneUsage;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EnhancedDynamicNetworkZone
 */
@JsonPropertyOrder({ EnhancedDynamicNetworkZone.JSON_PROPERTY_ASNS, EnhancedDynamicNetworkZone.JSON_PROPERTY_LOCATIONS,
        EnhancedDynamicNetworkZone.JSON_PROPERTY_IP_SERVICE_CATEGORIES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = EnhancedDynamicNetworkZone.class)

public class EnhancedDynamicNetworkZone extends NetworkZone implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ASNS = "asns";
    private EnhancedDynamicNetworkZoneAllOfAsns asns;

    public static final String JSON_PROPERTY_LOCATIONS = "locations";
    private EnhancedDynamicNetworkZoneAllOfLocations locations;

    public static final String JSON_PROPERTY_IP_SERVICE_CATEGORIES = "ipServiceCategories";
    private EnhancedDynamicNetworkZoneAllOfIpServiceCategories ipServiceCategories;

    public EnhancedDynamicNetworkZone() {
    }

    /*
     * @JsonCreator public EnhancedDynamicNetworkZone(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_SYSTEM) Boolean system ) { this(); this.created = created; this.id = id;
     * this.lastUpdated = lastUpdated; this.system = system; }
     */

    public EnhancedDynamicNetworkZone asns(EnhancedDynamicNetworkZoneAllOfAsns asns) {

        this.asns = asns;
        return this;
    }

    /**
     * Get asns
     *
     * @return asns
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ASNS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EnhancedDynamicNetworkZoneAllOfAsns getAsns() {
        return asns;
    }

    @JsonProperty(JSON_PROPERTY_ASNS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAsns(EnhancedDynamicNetworkZoneAllOfAsns asns) {
        this.asns = asns;
    }

    public EnhancedDynamicNetworkZone locations(EnhancedDynamicNetworkZoneAllOfLocations locations) {

        this.locations = locations;
        return this;
    }

    /**
     * Get locations
     *
     * @return locations
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LOCATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EnhancedDynamicNetworkZoneAllOfLocations getLocations() {
        return locations;
    }

    @JsonProperty(JSON_PROPERTY_LOCATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLocations(EnhancedDynamicNetworkZoneAllOfLocations locations) {
        this.locations = locations;
    }

    public EnhancedDynamicNetworkZone ipServiceCategories(
            EnhancedDynamicNetworkZoneAllOfIpServiceCategories ipServiceCategories) {

        this.ipServiceCategories = ipServiceCategories;
        return this;
    }

    /**
     * Get ipServiceCategories
     *
     * @return ipServiceCategories
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_IP_SERVICE_CATEGORIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EnhancedDynamicNetworkZoneAllOfIpServiceCategories getIpServiceCategories() {
        return ipServiceCategories;
    }

    @JsonProperty(JSON_PROPERTY_IP_SERVICE_CATEGORIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIpServiceCategories(EnhancedDynamicNetworkZoneAllOfIpServiceCategories ipServiceCategories) {
        this.ipServiceCategories = ipServiceCategories;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EnhancedDynamicNetworkZone enhancedDynamicNetworkZone = (EnhancedDynamicNetworkZone) o;
        return Objects.equals(this.asns, enhancedDynamicNetworkZone.asns)
                && Objects.equals(this.locations, enhancedDynamicNetworkZone.locations)
                && Objects.equals(this.ipServiceCategories, enhancedDynamicNetworkZone.ipServiceCategories);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(asns, locations, ipServiceCategories, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnhancedDynamicNetworkZone {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    asns: ").append(toIndentedString(asns)).append("\n");
        sb.append("    locations: ").append(toIndentedString(locations)).append("\n");
        sb.append("    ipServiceCategories: ").append(toIndentedString(ipServiceCategories)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
