package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Brand;
import com.okta.sdk.resource.model.EmailDomainDNSRecord;
import com.okta.sdk.resource.model.EmailDomainStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * EmailDomainResponseWithEmbedded
 */
@JsonPropertyOrder({ EmailDomainResponseWithEmbedded.JSON_PROPERTY_EMBEDDED,
        EmailDomainResponseWithEmbedded.JSON_PROPERTY_DNS_VALIDATION_RECORDS,
        EmailDomainResponseWithEmbedded.JSON_PROPERTY_DOMAIN, EmailDomainResponseWithEmbedded.JSON_PROPERTY_ID,
        EmailDomainResponseWithEmbedded.JSON_PROPERTY_VALIDATION_STATUS,
        EmailDomainResponseWithEmbedded.JSON_PROPERTY_VALIDATION_SUBDOMAIN,
        EmailDomainResponseWithEmbedded.JSON_PROPERTY_DISPLAY_NAME,
        EmailDomainResponseWithEmbedded.JSON_PROPERTY_USER_NAME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class EmailDomainResponseWithEmbedded implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Object embedded;

    public static final String JSON_PROPERTY_DNS_VALIDATION_RECORDS = "dnsValidationRecords";
    private List<EmailDomainDNSRecord> dnsValidationRecords = null;

    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_VALIDATION_STATUS = "validationStatus";
    private EmailDomainStatus validationStatus;

    public static final String JSON_PROPERTY_VALIDATION_SUBDOMAIN = "validationSubdomain";
    private String validationSubdomain = "mail";

    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;

    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public EmailDomainResponseWithEmbedded() {
    }

    /*
     * @JsonCreator public EmailDomainResponseWithEmbedded(
     *
     * @JsonProperty(JSON_PROPERTY_EMBEDDED) Object embedded ) { this(); this.embedded = embedded; }
     */

    /**
     * Get embedded
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getEmbedded() {
        return embedded;
    }

    public EmailDomainResponseWithEmbedded dnsValidationRecords(List<EmailDomainDNSRecord> dnsValidationRecords) {

        this.dnsValidationRecords = dnsValidationRecords;
        return this;
    }

    public EmailDomainResponseWithEmbedded adddnsValidationRecordsItem(EmailDomainDNSRecord dnsValidationRecordsItem) {
        if (this.dnsValidationRecords == null) {
            this.dnsValidationRecords = new ArrayList<>();
        }
        this.dnsValidationRecords.add(dnsValidationRecordsItem);
        return this;
    }

    /**
     * Get dnsValidationRecords
     *
     * @return dnsValidationRecords
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DNS_VALIDATION_RECORDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<EmailDomainDNSRecord> getDnsValidationRecords() {
        return dnsValidationRecords;
    }

    @JsonProperty(JSON_PROPERTY_DNS_VALIDATION_RECORDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDnsValidationRecords(List<EmailDomainDNSRecord> dnsValidationRecords) {
        this.dnsValidationRecords = dnsValidationRecords;
    }

    public EmailDomainResponseWithEmbedded domain(String domain) {

        this.domain = domain;
        return this;
    }

    /**
     * Get domain
     *
     * @return domain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDomain() {
        return domain;
    }

    @JsonProperty(JSON_PROPERTY_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public EmailDomainResponseWithEmbedded id(String id) {

        this.id = id;
        return this;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public EmailDomainResponseWithEmbedded validationStatus(EmailDomainStatus validationStatus) {

        this.validationStatus = validationStatus;
        return this;
    }

    /**
     * Get validationStatus
     *
     * @return validationStatus
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VALIDATION_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public EmailDomainStatus getValidationStatus() {
        return validationStatus;
    }

    @JsonProperty(JSON_PROPERTY_VALIDATION_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValidationStatus(EmailDomainStatus validationStatus) {
        this.validationStatus = validationStatus;
    }

    public EmailDomainResponseWithEmbedded validationSubdomain(String validationSubdomain) {

        this.validationSubdomain = validationSubdomain;
        return this;
    }

    /**
     * The subdomain for the email sender&#39;s custom mail domain
     *
     * @return validationSubdomain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The subdomain for the email sender's custom mail domain")
    @JsonProperty(JSON_PROPERTY_VALIDATION_SUBDOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValidationSubdomain() {
        return validationSubdomain;
    }

    @JsonProperty(JSON_PROPERTY_VALIDATION_SUBDOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValidationSubdomain(String validationSubdomain) {
        this.validationSubdomain = validationSubdomain;
    }

    public EmailDomainResponseWithEmbedded displayName(String displayName) {

        this.displayName = displayName;
        return this;
    }

    /**
     * Get displayName
     *
     * @return displayName
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getDisplayName() {
        return displayName;
    }

    @JsonProperty(JSON_PROPERTY_DISPLAY_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public EmailDomainResponseWithEmbedded userName(String userName) {

        this.userName = userName;
        return this;
    }

    /**
     * Get userName
     *
     * @return userName
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUserName() {
        return userName;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmailDomainResponseWithEmbedded emailDomainResponseWithEmbedded = (EmailDomainResponseWithEmbedded) o;
        return Objects.equals(this.embedded, emailDomainResponseWithEmbedded.embedded)
                && Objects.equals(this.dnsValidationRecords, emailDomainResponseWithEmbedded.dnsValidationRecords)
                && Objects.equals(this.domain, emailDomainResponseWithEmbedded.domain)
                && Objects.equals(this.id, emailDomainResponseWithEmbedded.id)
                && Objects.equals(this.validationStatus, emailDomainResponseWithEmbedded.validationStatus)
                && Objects.equals(this.validationSubdomain, emailDomainResponseWithEmbedded.validationSubdomain)
                && Objects.equals(this.displayName, emailDomainResponseWithEmbedded.displayName)
                && Objects.equals(this.userName, emailDomainResponseWithEmbedded.userName);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(embedded, dnsValidationRecords, domain, id, validationStatus, validationSubdomain,
                displayName, userName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailDomainResponseWithEmbedded {\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    dnsValidationRecords: ").append(toIndentedString(dnsValidationRecords)).append("\n");
        sb.append("    domain: ").append(toIndentedString(domain)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    validationStatus: ").append(toIndentedString(validationStatus)).append("\n");
        sb.append("    validationSubdomain: ").append(toIndentedString(validationSubdomain)).append("\n");
        sb.append("    displayName: ").append(toIndentedString(displayName)).append("\n");
        sb.append("    userName: ").append(toIndentedString(userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
