package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ChromeBrowserVersion;
import com.okta.sdk.resource.model.KeyTrustLevelBrowserKey;
import com.okta.sdk.resource.model.OSVersionFourComponents;
import com.okta.sdk.resource.model.PasswordProtectionWarningTrigger;
import com.okta.sdk.resource.model.SafeBrowsingProtectionLevel;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Google Chrome Device Trust Connector provider
 */
@ApiModel(description = "Google Chrome Device Trust Connector provider")
@JsonPropertyOrder({ DTCWindows.JSON_PROPERTY_BROWSER_VERSION, DTCWindows.JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED,
        DTCWindows.JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED, DTCWindows.JSON_PROPERTY_CROWD_STRIKE_AGENT_ID,
        DTCWindows.JSON_PROPERTY_CROWD_STRIKE_CUSTOMER_ID, DTCWindows.JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN,
        DTCWindows.JSON_PROPERTY_DISK_ENCRYPTED, DTCWindows.JSON_PROPERTY_KEY_TRUST_LEVEL,
        DTCWindows.JSON_PROPERTY_OS_FIREWALL, DTCWindows.JSON_PROPERTY_OS_VERSION,
        DTCWindows.JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER, DTCWindows.JSON_PROPERTY_REALTIME_URL_CHECK_MODE,
        DTCWindows.JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL, DTCWindows.JSON_PROPERTY_SCREEN_LOCK_SECURED,
        DTCWindows.JSON_PROPERTY_SECURE_BOOT_ENABLED, DTCWindows.JSON_PROPERTY_SITE_ISOLATION_ENABLED,
        DTCWindows.JSON_PROPERTY_THIRD_PARTY_BLOCKING_ENABLED, DTCWindows.JSON_PROPERTY_WINDOWS_MACHINE_DOMAIN,
        DTCWindows.JSON_PROPERTY_WINDOWS_USER_DOMAIN })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class DTCWindows implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_BROWSER_VERSION = "browserVersion";
    private ChromeBrowserVersion browserVersion;

    public static final String JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED = "builtInDnsClientEnabled";
    private Boolean builtInDnsClientEnabled;

    public static final String JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED = "chromeRemoteDesktopAppBlocked";
    private Boolean chromeRemoteDesktopAppBlocked;

    public static final String JSON_PROPERTY_CROWD_STRIKE_AGENT_ID = "crowdStrikeAgentId";
    private String crowdStrikeAgentId;

    public static final String JSON_PROPERTY_CROWD_STRIKE_CUSTOMER_ID = "crowdStrikeCustomerId";
    private String crowdStrikeCustomerId;

    public static final String JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN = "deviceEnrollmentDomain";
    private String deviceEnrollmentDomain;

    public static final String JSON_PROPERTY_DISK_ENCRYPTED = "diskEncrypted";
    private Boolean diskEncrypted;

    public static final String JSON_PROPERTY_KEY_TRUST_LEVEL = "keyTrustLevel";
    private KeyTrustLevelBrowserKey keyTrustLevel;

    public static final String JSON_PROPERTY_OS_FIREWALL = "osFirewall";
    private Boolean osFirewall;

    public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
    private OSVersionFourComponents osVersion;

    public static final String JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER = "passwordProtectionWarningTrigger";
    private PasswordProtectionWarningTrigger passwordProtectionWarningTrigger;

    public static final String JSON_PROPERTY_REALTIME_URL_CHECK_MODE = "realtimeUrlCheckMode";
    private Boolean realtimeUrlCheckMode;

    public static final String JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL = "safeBrowsingProtectionLevel";
    private SafeBrowsingProtectionLevel safeBrowsingProtectionLevel;

    public static final String JSON_PROPERTY_SCREEN_LOCK_SECURED = "screenLockSecured";
    private Boolean screenLockSecured;

    public static final String JSON_PROPERTY_SECURE_BOOT_ENABLED = "secureBootEnabled";
    private Boolean secureBootEnabled;

    public static final String JSON_PROPERTY_SITE_ISOLATION_ENABLED = "siteIsolationEnabled";
    private Boolean siteIsolationEnabled;

    public static final String JSON_PROPERTY_THIRD_PARTY_BLOCKING_ENABLED = "thirdPartyBlockingEnabled";
    private Boolean thirdPartyBlockingEnabled;

    public static final String JSON_PROPERTY_WINDOWS_MACHINE_DOMAIN = "windowsMachineDomain";
    private String windowsMachineDomain;

    public static final String JSON_PROPERTY_WINDOWS_USER_DOMAIN = "windowsUserDomain";
    private String windowsUserDomain;

    public DTCWindows() {
    }

    public DTCWindows browserVersion(ChromeBrowserVersion browserVersion) {

        this.browserVersion = browserVersion;
        return this;
    }

    /**
     * Get browserVersion
     *
     * @return browserVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_BROWSER_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ChromeBrowserVersion getBrowserVersion() {
        return browserVersion;
    }

    @JsonProperty(JSON_PROPERTY_BROWSER_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBrowserVersion(ChromeBrowserVersion browserVersion) {
        this.browserVersion = browserVersion;
    }

    public DTCWindows builtInDnsClientEnabled(Boolean builtInDnsClientEnabled) {

        this.builtInDnsClientEnabled = builtInDnsClientEnabled;
        return this;
    }

    /**
     * Indicates if a software stack is used to communicate with the DNS server
     *
     * @return builtInDnsClientEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if a software stack is used to communicate with the DNS server")
    @JsonProperty(JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getBuiltInDnsClientEnabled() {
        return builtInDnsClientEnabled;
    }

    @JsonProperty(JSON_PROPERTY_BUILT_IN_DNS_CLIENT_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setBuiltInDnsClientEnabled(Boolean builtInDnsClientEnabled) {
        this.builtInDnsClientEnabled = builtInDnsClientEnabled;
    }

    public DTCWindows chromeRemoteDesktopAppBlocked(Boolean chromeRemoteDesktopAppBlocked) {

        this.chromeRemoteDesktopAppBlocked = chromeRemoteDesktopAppBlocked;
        return this;
    }

    /**
     * Indicates whether access to the Chrome Remote Desktop application is blocked through a policy
     *
     * @return chromeRemoteDesktopAppBlocked
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether access to the Chrome Remote Desktop application is blocked through a policy")
    @JsonProperty(JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getChromeRemoteDesktopAppBlocked() {
        return chromeRemoteDesktopAppBlocked;
    }

    @JsonProperty(JSON_PROPERTY_CHROME_REMOTE_DESKTOP_APP_BLOCKED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setChromeRemoteDesktopAppBlocked(Boolean chromeRemoteDesktopAppBlocked) {
        this.chromeRemoteDesktopAppBlocked = chromeRemoteDesktopAppBlocked;
    }

    public DTCWindows crowdStrikeAgentId(String crowdStrikeAgentId) {

        this.crowdStrikeAgentId = crowdStrikeAgentId;
        return this;
    }

    /**
     * Agent ID of an installed CrowdStrike agent
     *
     * @return crowdStrikeAgentId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Agent ID of an installed CrowdStrike agent")
    @JsonProperty(JSON_PROPERTY_CROWD_STRIKE_AGENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCrowdStrikeAgentId() {
        return crowdStrikeAgentId;
    }

    @JsonProperty(JSON_PROPERTY_CROWD_STRIKE_AGENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCrowdStrikeAgentId(String crowdStrikeAgentId) {
        this.crowdStrikeAgentId = crowdStrikeAgentId;
    }

    public DTCWindows crowdStrikeCustomerId(String crowdStrikeCustomerId) {

        this.crowdStrikeCustomerId = crowdStrikeCustomerId;
        return this;
    }

    /**
     * Customer ID of an installed CrowdStrike agent
     *
     * @return crowdStrikeCustomerId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Customer ID of an installed CrowdStrike agent")
    @JsonProperty(JSON_PROPERTY_CROWD_STRIKE_CUSTOMER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getCrowdStrikeCustomerId() {
        return crowdStrikeCustomerId;
    }

    @JsonProperty(JSON_PROPERTY_CROWD_STRIKE_CUSTOMER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCrowdStrikeCustomerId(String crowdStrikeCustomerId) {
        this.crowdStrikeCustomerId = crowdStrikeCustomerId;
    }

    public DTCWindows deviceEnrollmentDomain(String deviceEnrollmentDomain) {

        this.deviceEnrollmentDomain = deviceEnrollmentDomain;
        return this;
    }

    /**
     * Enrollment domain of the customer that is currently managing the device
     *
     * @return deviceEnrollmentDomain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Enrollment domain of the customer that is currently managing the device")
    @JsonProperty(JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDeviceEnrollmentDomain() {
        return deviceEnrollmentDomain;
    }

    @JsonProperty(JSON_PROPERTY_DEVICE_ENROLLMENT_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceEnrollmentDomain(String deviceEnrollmentDomain) {
        this.deviceEnrollmentDomain = deviceEnrollmentDomain;
    }

    public DTCWindows diskEncrypted(Boolean diskEncrypted) {

        this.diskEncrypted = diskEncrypted;
        return this;
    }

    /**
     * Indicates whether the main disk is encrypted
     *
     * @return diskEncrypted
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the main disk is encrypted")
    @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getDiskEncrypted() {
        return diskEncrypted;
    }

    @JsonProperty(JSON_PROPERTY_DISK_ENCRYPTED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDiskEncrypted(Boolean diskEncrypted) {
        this.diskEncrypted = diskEncrypted;
    }

    public DTCWindows keyTrustLevel(KeyTrustLevelBrowserKey keyTrustLevel) {

        this.keyTrustLevel = keyTrustLevel;
        return this;
    }

    /**
     * Get keyTrustLevel
     *
     * @return keyTrustLevel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_KEY_TRUST_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public KeyTrustLevelBrowserKey getKeyTrustLevel() {
        return keyTrustLevel;
    }

    @JsonProperty(JSON_PROPERTY_KEY_TRUST_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setKeyTrustLevel(KeyTrustLevelBrowserKey keyTrustLevel) {
        this.keyTrustLevel = keyTrustLevel;
    }

    public DTCWindows osFirewall(Boolean osFirewall) {

        this.osFirewall = osFirewall;
        return this;
    }

    /**
     * Indicates whether a firewall is enabled at the OS-level on the device
     *
     * @return osFirewall
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether a firewall is enabled at the OS-level on the device")
    @JsonProperty(JSON_PROPERTY_OS_FIREWALL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getOsFirewall() {
        return osFirewall;
    }

    @JsonProperty(JSON_PROPERTY_OS_FIREWALL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOsFirewall(Boolean osFirewall) {
        this.osFirewall = osFirewall;
    }

    public DTCWindows osVersion(OSVersionFourComponents osVersion) {

        this.osVersion = osVersion;
        return this;
    }

    /**
     * Get osVersion
     *
     * @return osVersion
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_OS_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OSVersionFourComponents getOsVersion() {
        return osVersion;
    }

    @JsonProperty(JSON_PROPERTY_OS_VERSION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setOsVersion(OSVersionFourComponents osVersion) {
        this.osVersion = osVersion;
    }

    public DTCWindows passwordProtectionWarningTrigger(
            PasswordProtectionWarningTrigger passwordProtectionWarningTrigger) {

        this.passwordProtectionWarningTrigger = passwordProtectionWarningTrigger;
        return this;
    }

    /**
     * Get passwordProtectionWarningTrigger
     *
     * @return passwordProtectionWarningTrigger
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordProtectionWarningTrigger getPasswordProtectionWarningTrigger() {
        return passwordProtectionWarningTrigger;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_PROTECTION_WARNING_TRIGGER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordProtectionWarningTrigger(PasswordProtectionWarningTrigger passwordProtectionWarningTrigger) {
        this.passwordProtectionWarningTrigger = passwordProtectionWarningTrigger;
    }

    public DTCWindows realtimeUrlCheckMode(Boolean realtimeUrlCheckMode) {

        this.realtimeUrlCheckMode = realtimeUrlCheckMode;
        return this;
    }

    /**
     * Indicates whether enterprise-grade (custom) unsafe URL scanning is enabled
     *
     * @return realtimeUrlCheckMode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether enterprise-grade (custom) unsafe URL scanning is enabled")
    @JsonProperty(JSON_PROPERTY_REALTIME_URL_CHECK_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getRealtimeUrlCheckMode() {
        return realtimeUrlCheckMode;
    }

    @JsonProperty(JSON_PROPERTY_REALTIME_URL_CHECK_MODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRealtimeUrlCheckMode(Boolean realtimeUrlCheckMode) {
        this.realtimeUrlCheckMode = realtimeUrlCheckMode;
    }

    public DTCWindows safeBrowsingProtectionLevel(SafeBrowsingProtectionLevel safeBrowsingProtectionLevel) {

        this.safeBrowsingProtectionLevel = safeBrowsingProtectionLevel;
        return this;
    }

    /**
     * Get safeBrowsingProtectionLevel
     *
     * @return safeBrowsingProtectionLevel
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SafeBrowsingProtectionLevel getSafeBrowsingProtectionLevel() {
        return safeBrowsingProtectionLevel;
    }

    @JsonProperty(JSON_PROPERTY_SAFE_BROWSING_PROTECTION_LEVEL)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSafeBrowsingProtectionLevel(SafeBrowsingProtectionLevel safeBrowsingProtectionLevel) {
        this.safeBrowsingProtectionLevel = safeBrowsingProtectionLevel;
    }

    public DTCWindows screenLockSecured(Boolean screenLockSecured) {

        this.screenLockSecured = screenLockSecured;
        return this;
    }

    /**
     * Indicates whether the device is password-protected
     *
     * @return screenLockSecured
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the device is password-protected")
    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_SECURED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getScreenLockSecured() {
        return screenLockSecured;
    }

    @JsonProperty(JSON_PROPERTY_SCREEN_LOCK_SECURED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockSecured(Boolean screenLockSecured) {
        this.screenLockSecured = screenLockSecured;
    }

    public DTCWindows secureBootEnabled(Boolean secureBootEnabled) {

        this.secureBootEnabled = secureBootEnabled;
        return this;
    }

    /**
     * Indicates whether the device&#39;s startup software has its Secure Boot feature enabled
     *
     * @return secureBootEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the device's startup software has its Secure Boot feature enabled")
    @JsonProperty(JSON_PROPERTY_SECURE_BOOT_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSecureBootEnabled() {
        return secureBootEnabled;
    }

    @JsonProperty(JSON_PROPERTY_SECURE_BOOT_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSecureBootEnabled(Boolean secureBootEnabled) {
        this.secureBootEnabled = secureBootEnabled;
    }

    public DTCWindows siteIsolationEnabled(Boolean siteIsolationEnabled) {

        this.siteIsolationEnabled = siteIsolationEnabled;
        return this;
    }

    /**
     * Indicates whether the Site Isolation (also known as **Site Per Process**) setting is enabled
     *
     * @return siteIsolationEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether the Site Isolation (also known as **Site Per Process**) setting is enabled")
    @JsonProperty(JSON_PROPERTY_SITE_ISOLATION_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSiteIsolationEnabled() {
        return siteIsolationEnabled;
    }

    @JsonProperty(JSON_PROPERTY_SITE_ISOLATION_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSiteIsolationEnabled(Boolean siteIsolationEnabled) {
        this.siteIsolationEnabled = siteIsolationEnabled;
    }

    public DTCWindows thirdPartyBlockingEnabled(Boolean thirdPartyBlockingEnabled) {

        this.thirdPartyBlockingEnabled = thirdPartyBlockingEnabled;
        return this;
    }

    /**
     * Indicates whether Chrome is blocking third-party software injection
     *
     * @return thirdPartyBlockingEnabled
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates whether Chrome is blocking third-party software injection")
    @JsonProperty(JSON_PROPERTY_THIRD_PARTY_BLOCKING_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getThirdPartyBlockingEnabled() {
        return thirdPartyBlockingEnabled;
    }

    @JsonProperty(JSON_PROPERTY_THIRD_PARTY_BLOCKING_ENABLED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setThirdPartyBlockingEnabled(Boolean thirdPartyBlockingEnabled) {
        this.thirdPartyBlockingEnabled = thirdPartyBlockingEnabled;
    }

    public DTCWindows windowsMachineDomain(String windowsMachineDomain) {

        this.windowsMachineDomain = windowsMachineDomain;
        return this;
    }

    /**
     * Windows domain that the current machine has joined
     *
     * @return windowsMachineDomain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Windows domain that the current machine has joined")
    @JsonProperty(JSON_PROPERTY_WINDOWS_MACHINE_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getWindowsMachineDomain() {
        return windowsMachineDomain;
    }

    @JsonProperty(JSON_PROPERTY_WINDOWS_MACHINE_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setWindowsMachineDomain(String windowsMachineDomain) {
        this.windowsMachineDomain = windowsMachineDomain;
    }

    public DTCWindows windowsUserDomain(String windowsUserDomain) {

        this.windowsUserDomain = windowsUserDomain;
        return this;
    }

    /**
     * Windows domain for the current OS user
     *
     * @return windowsUserDomain
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Windows domain for the current OS user")
    @JsonProperty(JSON_PROPERTY_WINDOWS_USER_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getWindowsUserDomain() {
        return windowsUserDomain;
    }

    @JsonProperty(JSON_PROPERTY_WINDOWS_USER_DOMAIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setWindowsUserDomain(String windowsUserDomain) {
        this.windowsUserDomain = windowsUserDomain;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DTCWindows dtCWindows = (DTCWindows) o;
        return Objects.equals(this.browserVersion, dtCWindows.browserVersion)
                && Objects.equals(this.builtInDnsClientEnabled, dtCWindows.builtInDnsClientEnabled)
                && Objects.equals(this.chromeRemoteDesktopAppBlocked, dtCWindows.chromeRemoteDesktopAppBlocked)
                && Objects.equals(this.crowdStrikeAgentId, dtCWindows.crowdStrikeAgentId)
                && Objects.equals(this.crowdStrikeCustomerId, dtCWindows.crowdStrikeCustomerId)
                && Objects.equals(this.deviceEnrollmentDomain, dtCWindows.deviceEnrollmentDomain)
                && Objects.equals(this.diskEncrypted, dtCWindows.diskEncrypted)
                && Objects.equals(this.keyTrustLevel, dtCWindows.keyTrustLevel)
                && Objects.equals(this.osFirewall, dtCWindows.osFirewall)
                && Objects.equals(this.osVersion, dtCWindows.osVersion)
                && Objects.equals(this.passwordProtectionWarningTrigger, dtCWindows.passwordProtectionWarningTrigger)
                && Objects.equals(this.realtimeUrlCheckMode, dtCWindows.realtimeUrlCheckMode)
                && Objects.equals(this.safeBrowsingProtectionLevel, dtCWindows.safeBrowsingProtectionLevel)
                && Objects.equals(this.screenLockSecured, dtCWindows.screenLockSecured)
                && Objects.equals(this.secureBootEnabled, dtCWindows.secureBootEnabled)
                && Objects.equals(this.siteIsolationEnabled, dtCWindows.siteIsolationEnabled)
                && Objects.equals(this.thirdPartyBlockingEnabled, dtCWindows.thirdPartyBlockingEnabled)
                && Objects.equals(this.windowsMachineDomain, dtCWindows.windowsMachineDomain)
                && Objects.equals(this.windowsUserDomain, dtCWindows.windowsUserDomain);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(browserVersion, builtInDnsClientEnabled, chromeRemoteDesktopAppBlocked, crowdStrikeAgentId,
                crowdStrikeCustomerId, deviceEnrollmentDomain, diskEncrypted, keyTrustLevel, osFirewall, osVersion,
                passwordProtectionWarningTrigger, realtimeUrlCheckMode, safeBrowsingProtectionLevel, screenLockSecured,
                secureBootEnabled, siteIsolationEnabled, thirdPartyBlockingEnabled, windowsMachineDomain,
                windowsUserDomain);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DTCWindows {\n");
        sb.append("    browserVersion: ").append(toIndentedString(browserVersion)).append("\n");
        sb.append("    builtInDnsClientEnabled: ").append(toIndentedString(builtInDnsClientEnabled)).append("\n");
        sb.append("    chromeRemoteDesktopAppBlocked: ").append(toIndentedString(chromeRemoteDesktopAppBlocked))
                .append("\n");
        sb.append("    crowdStrikeAgentId: ").append(toIndentedString(crowdStrikeAgentId)).append("\n");
        sb.append("    crowdStrikeCustomerId: ").append(toIndentedString(crowdStrikeCustomerId)).append("\n");
        sb.append("    deviceEnrollmentDomain: ").append(toIndentedString(deviceEnrollmentDomain)).append("\n");
        sb.append("    diskEncrypted: ").append(toIndentedString(diskEncrypted)).append("\n");
        sb.append("    keyTrustLevel: ").append(toIndentedString(keyTrustLevel)).append("\n");
        sb.append("    osFirewall: ").append(toIndentedString(osFirewall)).append("\n");
        sb.append("    osVersion: ").append(toIndentedString(osVersion)).append("\n");
        sb.append("    passwordProtectionWarningTrigger: ").append(toIndentedString(passwordProtectionWarningTrigger))
                .append("\n");
        sb.append("    realtimeUrlCheckMode: ").append(toIndentedString(realtimeUrlCheckMode)).append("\n");
        sb.append("    safeBrowsingProtectionLevel: ").append(toIndentedString(safeBrowsingProtectionLevel))
                .append("\n");
        sb.append("    screenLockSecured: ").append(toIndentedString(screenLockSecured)).append("\n");
        sb.append("    secureBootEnabled: ").append(toIndentedString(secureBootEnabled)).append("\n");
        sb.append("    siteIsolationEnabled: ").append(toIndentedString(siteIsolationEnabled)).append("\n");
        sb.append("    thirdPartyBlockingEnabled: ").append(toIndentedString(thirdPartyBlockingEnabled)).append("\n");
        sb.append("    windowsMachineDomain: ").append(toIndentedString(windowsMachineDomain)).append("\n");
        sb.append("    windowsUserDomain: ").append(toIndentedString(windowsUserDomain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
