package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CredentialSyncState;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * CredentialSyncInfo
 */
@JsonPropertyOrder({ CredentialSyncInfo.JSON_PROPERTY_ERROR_CODE, CredentialSyncInfo.JSON_PROPERTY_ERROR_REASON,
        CredentialSyncInfo.JSON_PROPERTY_SECRET_VERSION_ID, CredentialSyncInfo.JSON_PROPERTY_SYNC_STATE,
        CredentialSyncInfo.JSON_PROPERTY_SYNC_TIME })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CredentialSyncInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private String errorCode;

    public static final String JSON_PROPERTY_ERROR_REASON = "errorReason";
    private String errorReason;

    public static final String JSON_PROPERTY_SECRET_VERSION_ID = "secretVersionId";
    private String secretVersionId;

    public static final String JSON_PROPERTY_SYNC_STATE = "syncState";
    private CredentialSyncState syncState;

    public static final String JSON_PROPERTY_SYNC_TIME = "syncTime";
    private OffsetDateTime syncTime;

    public CredentialSyncInfo() {
    }

    /*
     * @JsonCreator public CredentialSyncInfo(
     *
     * @JsonProperty(JSON_PROPERTY_ERROR_CODE) String errorCode,
     *
     * @JsonProperty(JSON_PROPERTY_ERROR_REASON) String errorReason,
     *
     * @JsonProperty(JSON_PROPERTY_SYNC_TIME) OffsetDateTime syncTime ) { this(); this.errorCode = errorCode;
     * this.errorReason = errorReason; this.syncTime = syncTime; }
     */

    /**
     * The error code for the type of error
     *
     * @return errorCode
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The error code for the type of error")
    @JsonProperty(JSON_PROPERTY_ERROR_CODE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorCode() {
        return errorCode;
    }

    /**
     * A short description of the error
     *
     * @return errorReason
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A short description of the error")
    @JsonProperty(JSON_PROPERTY_ERROR_REASON)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getErrorReason() {
        return errorReason;
    }

    public CredentialSyncInfo secretVersionId(String secretVersionId) {

        this.secretVersionId = secretVersionId;
        return this;
    }

    /**
     * The version ID of the password secret from the OPA vault.
     *
     * @return secretVersionId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "9f8400-e29b-41d4-a716-926655440034", value = "The version ID of the password secret from the OPA vault.")
    @JsonProperty(JSON_PROPERTY_SECRET_VERSION_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSecretVersionId() {
        return secretVersionId;
    }

    @JsonProperty(JSON_PROPERTY_SECRET_VERSION_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSecretVersionId(String secretVersionId) {
        this.secretVersionId = secretVersionId;
    }

    public CredentialSyncInfo syncState(CredentialSyncState syncState) {

        this.syncState = syncState;
        return this;
    }

    /**
     * Get syncState
     *
     * @return syncState
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SYNC_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CredentialSyncState getSyncState() {
        return syncState;
    }

    @JsonProperty(JSON_PROPERTY_SYNC_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSyncState(CredentialSyncState syncState) {
        this.syncState = syncState;
    }

    /**
     * Timestamp when the credential was changed
     *
     * @return syncTime
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2024-06-10T11:30:01Z", value = "Timestamp when the credential was changed")
    @JsonProperty(JSON_PROPERTY_SYNC_TIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getSyncTime() {
        return syncTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CredentialSyncInfo credentialSyncInfo = (CredentialSyncInfo) o;
        return Objects.equals(this.errorCode, credentialSyncInfo.errorCode)
                && Objects.equals(this.errorReason, credentialSyncInfo.errorReason)
                && Objects.equals(this.secretVersionId, credentialSyncInfo.secretVersionId)
                && Objects.equals(this.syncState, credentialSyncInfo.syncState)
                && Objects.equals(this.syncTime, credentialSyncInfo.syncTime);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(errorCode, errorReason, secretVersionId, syncState, syncTime);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CredentialSyncInfo {\n");
        sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
        sb.append("    errorReason: ").append(toIndentedString(errorReason)).append("\n");
        sb.append("    secretVersionId: ").append(toIndentedString(secretVersionId)).append("\n");
        sb.append("    syncState: ").append(toIndentedString(syncState)).append("\n");
        sb.append("    syncTime: ").append(toIndentedString(syncTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
