package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LifecycleCreateSettingObject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Determines whether Okta assigns a new app account to each user managed by Okta. Okta doesn&#39;t create a new account
 * if it detects that the username specified in Okta already exists in the app. The user&#39;s Okta username is assigned
 * by default.
 */
@ApiModel(description = "Determines whether Okta assigns a new app account to each user managed by Okta.  Okta doesn't create a new account if it detects that the username specified in Okta already exists in the app. The user's Okta username is assigned by default. ")
@JsonPropertyOrder({ CapabilitiesCreateObject.JSON_PROPERTY_LIFECYCLE_CREATE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CapabilitiesCreateObject implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_LIFECYCLE_CREATE = "lifecycleCreate";
    private LifecycleCreateSettingObject lifecycleCreate;

    public CapabilitiesCreateObject() {
    }

    public CapabilitiesCreateObject lifecycleCreate(LifecycleCreateSettingObject lifecycleCreate) {

        this.lifecycleCreate = lifecycleCreate;
        return this;
    }

    /**
     * Get lifecycleCreate
     *
     * @return lifecycleCreate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LIFECYCLE_CREATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleCreateSettingObject getLifecycleCreate() {
        return lifecycleCreate;
    }

    @JsonProperty(JSON_PROPERTY_LIFECYCLE_CREATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLifecycleCreate(LifecycleCreateSettingObject lifecycleCreate) {
        this.lifecycleCreate = lifecycleCreate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CapabilitiesCreateObject capabilitiesCreateObject = (CapabilitiesCreateObject) o;
        return Objects.equals(this.lifecycleCreate, capabilitiesCreateObject.lifecycleCreate);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(lifecycleCreate);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapabilitiesCreateObject {\n");
        sb.append("    lifecycleCreate: ").append(toIndentedString(lifecycleCreate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
