package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OtpTotpAlgorithm;
import com.okta.sdk.resource.model.OtpTotpEncoding;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorMethodTotpAllOfSettings
 */
@JsonPropertyOrder({ AuthenticatorMethodTotpAllOfSettings.JSON_PROPERTY_TIME_INTERVAL_IN_SECONDS,
        AuthenticatorMethodTotpAllOfSettings.JSON_PROPERTY_ENCODING,
        AuthenticatorMethodTotpAllOfSettings.JSON_PROPERTY_ALGORITHM,
        AuthenticatorMethodTotpAllOfSettings.JSON_PROPERTY_PASS_CODE_LENGTH })
@JsonTypeName("AuthenticatorMethodTotp_allOf_settings")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthenticatorMethodTotpAllOfSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_TIME_INTERVAL_IN_SECONDS = "timeIntervalInSeconds";
    private Integer timeIntervalInSeconds;

    public static final String JSON_PROPERTY_ENCODING = "encoding";
    private OtpTotpEncoding encoding;

    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private OtpTotpAlgorithm algorithm;

    public static final String JSON_PROPERTY_PASS_CODE_LENGTH = "passCodeLength";
    private Integer passCodeLength;

    public AuthenticatorMethodTotpAllOfSettings() {
    }

    public AuthenticatorMethodTotpAllOfSettings timeIntervalInSeconds(Integer timeIntervalInSeconds) {

        this.timeIntervalInSeconds = timeIntervalInSeconds;
        return this;
    }

    /**
     * Time interval for TOTP in seconds
     *
     * @return timeIntervalInSeconds
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Time interval for TOTP in seconds")
    @JsonProperty(JSON_PROPERTY_TIME_INTERVAL_IN_SECONDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getTimeIntervalInSeconds() {
        return timeIntervalInSeconds;
    }

    @JsonProperty(JSON_PROPERTY_TIME_INTERVAL_IN_SECONDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTimeIntervalInSeconds(Integer timeIntervalInSeconds) {
        this.timeIntervalInSeconds = timeIntervalInSeconds;
    }

    public AuthenticatorMethodTotpAllOfSettings encoding(OtpTotpEncoding encoding) {

        this.encoding = encoding;
        return this;
    }

    /**
     * Get encoding
     *
     * @return encoding
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ENCODING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OtpTotpEncoding getEncoding() {
        return encoding;
    }

    @JsonProperty(JSON_PROPERTY_ENCODING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEncoding(OtpTotpEncoding encoding) {
        this.encoding = encoding;
    }

    public AuthenticatorMethodTotpAllOfSettings algorithm(OtpTotpAlgorithm algorithm) {

        this.algorithm = algorithm;
        return this;
    }

    /**
     * Get algorithm
     *
     * @return algorithm
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OtpTotpAlgorithm getAlgorithm() {
        return algorithm;
    }

    @JsonProperty(JSON_PROPERTY_ALGORITHM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithm(OtpTotpAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public AuthenticatorMethodTotpAllOfSettings passCodeLength(Integer passCodeLength) {

        this.passCodeLength = passCodeLength;
        return this;
    }

    /**
     * Number of digits in an OTP value minimum: 6 maximum: 10
     *
     * @return passCodeLength
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Number of digits in an OTP value")
    @JsonProperty(JSON_PROPERTY_PASS_CODE_LENGTH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getPassCodeLength() {
        return passCodeLength;
    }

    @JsonProperty(JSON_PROPERTY_PASS_CODE_LENGTH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPassCodeLength(Integer passCodeLength) {
        this.passCodeLength = passCodeLength;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorMethodTotpAllOfSettings authenticatorMethodTotpAllOfSettings = (AuthenticatorMethodTotpAllOfSettings) o;
        return Objects.equals(this.timeIntervalInSeconds, authenticatorMethodTotpAllOfSettings.timeIntervalInSeconds)
                && Objects.equals(this.encoding, authenticatorMethodTotpAllOfSettings.encoding)
                && Objects.equals(this.algorithm, authenticatorMethodTotpAllOfSettings.algorithm)
                && Objects.equals(this.passCodeLength, authenticatorMethodTotpAllOfSettings.passCodeLength);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(timeIntervalInSeconds, encoding, algorithm, passCodeLength);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorMethodTotpAllOfSettings {\n");
        sb.append("    timeIntervalInSeconds: ").append(toIndentedString(timeIntervalInSeconds)).append("\n");
        sb.append("    encoding: ").append(toIndentedString(encoding)).append("\n");
        sb.append("    algorithm: ").append(toIndentedString(algorithm)).append("\n");
        sb.append("    passCodeLength: ").append(toIndentedString(passCodeLength)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
