package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationCredentialsSigning;
import com.okta.sdk.resource.model.ApplicationCredentialsUsernameTemplate;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Credentials for the specified &#x60;signOnMode&#x60;
 */
@ApiModel(description = "Credentials for the specified `signOnMode`")
@JsonPropertyOrder({ ApplicationCredentials.JSON_PROPERTY_SIGNING,
        ApplicationCredentials.JSON_PROPERTY_USER_NAME_TEMPLATE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ApplicationCredentials implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SIGNING = "signing";
    private ApplicationCredentialsSigning signing;

    public static final String JSON_PROPERTY_USER_NAME_TEMPLATE = "userNameTemplate";
    private ApplicationCredentialsUsernameTemplate userNameTemplate;

    public ApplicationCredentials() {
    }

    public ApplicationCredentials signing(ApplicationCredentialsSigning signing) {

        this.signing = signing;
        return this;
    }

    /**
     * Get signing
     *
     * @return signing
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentialsSigning getSigning() {
        return signing;
    }

    @JsonProperty(JSON_PROPERTY_SIGNING)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSigning(ApplicationCredentialsSigning signing) {
        this.signing = signing;
    }

    public ApplicationCredentials userNameTemplate(ApplicationCredentialsUsernameTemplate userNameTemplate) {

        this.userNameTemplate = userNameTemplate;
        return this;
    }

    /**
     * Get userNameTemplate
     *
     * @return userNameTemplate
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_NAME_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ApplicationCredentialsUsernameTemplate getUserNameTemplate() {
        return userNameTemplate;
    }

    @JsonProperty(JSON_PROPERTY_USER_NAME_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserNameTemplate(ApplicationCredentialsUsernameTemplate userNameTemplate) {
        this.userNameTemplate = userNameTemplate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ApplicationCredentials applicationCredentials = (ApplicationCredentials) o;
        return Objects.equals(this.signing, applicationCredentials.signing)
                && Objects.equals(this.userNameTemplate, applicationCredentials.userNameTemplate);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(signing, userNameTemplate);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationCredentials {\n");
        sb.append("    signing: ").append(toIndentedString(signing)).append("\n");
        sb.append("    userNameTemplate: ").append(toIndentedString(userNameTemplate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
