package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Settings specific to the Okta Admin Console
 */
@ApiModel(description = "Settings specific to the Okta Admin Console")
@JsonPropertyOrder({ AdminConsoleSettings.JSON_PROPERTY_SESSION_IDLE_TIMEOUT_MINUTES,
        AdminConsoleSettings.JSON_PROPERTY_SESSION_MAX_LIFETIME_MINUTES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AdminConsoleSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SESSION_IDLE_TIMEOUT_MINUTES = "sessionIdleTimeoutMinutes";
    private Integer sessionIdleTimeoutMinutes = 15;

    public static final String JSON_PROPERTY_SESSION_MAX_LIFETIME_MINUTES = "sessionMaxLifetimeMinutes";
    private Integer sessionMaxLifetimeMinutes = 720;

    public AdminConsoleSettings() {
    }

    public AdminConsoleSettings sessionIdleTimeoutMinutes(Integer sessionIdleTimeoutMinutes) {

        this.sessionIdleTimeoutMinutes = sessionIdleTimeoutMinutes;
        return this;
    }

    /**
     * The maximum idle time before the Okta Admin Console session expires. Must be no more than 12 hours. minimum: 5
     * maximum: 720
     *
     * @return sessionIdleTimeoutMinutes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The maximum idle time before the Okta Admin Console session expires. Must be no more than 12 hours.")
    @JsonProperty(JSON_PROPERTY_SESSION_IDLE_TIMEOUT_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getSessionIdleTimeoutMinutes() {
        return sessionIdleTimeoutMinutes;
    }

    @JsonProperty(JSON_PROPERTY_SESSION_IDLE_TIMEOUT_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSessionIdleTimeoutMinutes(Integer sessionIdleTimeoutMinutes) {
        this.sessionIdleTimeoutMinutes = sessionIdleTimeoutMinutes;
    }

    public AdminConsoleSettings sessionMaxLifetimeMinutes(Integer sessionMaxLifetimeMinutes) {

        this.sessionMaxLifetimeMinutes = sessionMaxLifetimeMinutes;
        return this;
    }

    /**
     * The absolute maximum session lifetime of the Okta Admin Console. Must be no more than 7 days. minimum: 5 maximum:
     * 10080
     *
     * @return sessionMaxLifetimeMinutes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The absolute maximum session lifetime of the Okta Admin Console. Must be no more than 7 days.")
    @JsonProperty(JSON_PROPERTY_SESSION_MAX_LIFETIME_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getSessionMaxLifetimeMinutes() {
        return sessionMaxLifetimeMinutes;
    }

    @JsonProperty(JSON_PROPERTY_SESSION_MAX_LIFETIME_MINUTES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSessionMaxLifetimeMinutes(Integer sessionMaxLifetimeMinutes) {
        this.sessionMaxLifetimeMinutes = sessionMaxLifetimeMinutes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AdminConsoleSettings adminConsoleSettings = (AdminConsoleSettings) o;
        return Objects.equals(this.sessionIdleTimeoutMinutes, adminConsoleSettings.sessionIdleTimeoutMinutes)
                && Objects.equals(this.sessionMaxLifetimeMinutes, adminConsoleSettings.sessionMaxLifetimeMinutes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(sessionIdleTimeoutMinutes, sessionMaxLifetimeMinutes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminConsoleSettings {\n");
        sb.append("    sessionIdleTimeoutMinutes: ").append(toIndentedString(sessionIdleTimeoutMinutes)).append("\n");
        sb.append("    sessionMaxLifetimeMinutes: ").append(toIndentedString(sessionMaxLifetimeMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
