/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ThreatInsightConfiguration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ThreatInsightApi {

    private ApiClient apiClient;

    public ThreatInsightApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ThreatInsightApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the ThreatInsight Configuration Retrieves the ThreatInsight configuration for the org
     *
     * @return ThreatInsightConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThreatInsightConfiguration getCurrentConfiguration() throws ApiException {
        return this.getCurrentConfiguration(Collections.emptyMap());
    }

    /**
     * Retrieve the ThreatInsight Configuration Retrieves the ThreatInsight configuration for the org
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ThreatInsightConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThreatInsightConfiguration getCurrentConfiguration(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/threats/configuration";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ThreatInsightConfiguration> localVarReturnType = new TypeReference<ThreatInsightConfiguration>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update the ThreatInsight Configuration Updates the ThreatInsight configuration for the org
     *
     * @param threatInsightConfiguration
     *            (required)
     *
     * @return ThreatInsightConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThreatInsightConfiguration updateConfiguration(ThreatInsightConfiguration threatInsightConfiguration)
            throws ApiException {
        return this.updateConfiguration(threatInsightConfiguration, Collections.emptyMap());
    }

    /**
     * Update the ThreatInsight Configuration Updates the ThreatInsight configuration for the org
     *
     * @param threatInsightConfiguration
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ThreatInsightConfiguration
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThreatInsightConfiguration updateConfiguration(ThreatInsightConfiguration threatInsightConfiguration,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = threatInsightConfiguration;

        // verify the required parameter 'threatInsightConfiguration' is set
        if (threatInsightConfiguration == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'threatInsightConfiguration' when calling updateConfiguration");
        }

        // create path and map variables
        String localVarPath = "/api/v1/threats/configuration";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ThreatInsightConfiguration> localVarReturnType = new TypeReference<ThreatInsightConfiguration>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
