/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AssignRoleToUser201Response;
import com.okta.sdk.resource.model.AssignRoleToUserRequest;
import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ListGroupAssignedRoles200ResponseInner;
import com.okta.sdk.resource.model.RoleAssignedUsers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RoleAssignmentAUserApi {

    private ApiClient apiClient;

    public RoleAssignmentAUserApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleAssignmentAUserApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Assign a User Role Assigns a [standard role](/openapi/okta-management/guides/roles/#standard-roles) to a User.
     * You can also assign a custom role to a User, but the preferred method to assign a custom role to a User is to
     * create a binding between the Custom Role, the Resource Set, and the User. See [Create a Role Resource Set
     * Binding](/openapi/okta-management/management/tag/RoleDResourceSetBinding/#tag/RoleDResourceSetBinding/operation/createResourceSetBinding).
     * &gt; **Notes:** &gt; * The request payload is different for standard and custom role assignments. &gt; * For
     * IAM-based standard role assignments, use the request payload for standard roles. However, the response payload
     * for IAM-based role assignments is similar to the custom role&#39;s assignment response.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param assignRoleRequest
     *            (required)
     * @param disableNotifications
     *            Setting this to &#x60;true&#x60; grants the User third-party admin status (optional, default to false)
     *
     * @return AssignRoleToUser201Response
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AssignRoleToUser201Response assignRoleToUser(String userId, AssignRoleToUserRequest assignRoleRequest,
            Boolean disableNotifications) throws ApiException {
        return this.assignRoleToUser(userId, assignRoleRequest, disableNotifications, Collections.emptyMap());
    }

    /**
     * Assign a User Role Assigns a [standard role](/openapi/okta-management/guides/roles/#standard-roles) to a User.
     * You can also assign a custom role to a User, but the preferred method to assign a custom role to a User is to
     * create a binding between the Custom Role, the Resource Set, and the User. See [Create a Role Resource Set
     * Binding](/openapi/okta-management/management/tag/RoleDResourceSetBinding/#tag/RoleDResourceSetBinding/operation/createResourceSetBinding).
     * &gt; **Notes:** &gt; * The request payload is different for standard and custom role assignments. &gt; * For
     * IAM-based standard role assignments, use the request payload for standard roles. However, the response payload
     * for IAM-based role assignments is similar to the custom role&#39;s assignment response.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param assignRoleRequest
     *            (required)
     * @param disableNotifications
     *            Setting this to &#x60;true&#x60; grants the User third-party admin status (optional, default to false)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AssignRoleToUser201Response
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AssignRoleToUser201Response assignRoleToUser(String userId, AssignRoleToUserRequest assignRoleRequest,
            Boolean disableNotifications, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = assignRoleRequest;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignRoleToUser");
        }

        // verify the required parameter 'assignRoleRequest' is set
        if (assignRoleRequest == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'assignRoleRequest' when calling assignRoleToUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("disableNotifications", disableNotifications));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AssignRoleToUser201Response> localVarReturnType = new TypeReference<AssignRoleToUser201Response>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a User Role Assignment Retrieves a Role assigned to a User (identified by &#x60;userId&#x60;). The
     * &#x60;roleAssignmentId&#x60; parameter is the unique identifier for either a standard Role Assignment object or a
     * custom role Resource Set Binding object.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner getUserAssignedRole(String userId, String roleAssignmentId)
            throws ApiException {
        return this.getUserAssignedRole(userId, roleAssignmentId, Collections.emptyMap());
    }

    /**
     * Retrieve a User Role Assignment Retrieves a Role assigned to a User (identified by &#x60;userId&#x60;). The
     * &#x60;roleAssignmentId&#x60; parameter is the unique identifier for either a standard Role Assignment object or a
     * custom role Resource Set Binding object.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ListGroupAssignedRoles200ResponseInner
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ListGroupAssignedRoles200ResponseInner getUserAssignedRole(String userId, String roleAssignmentId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserAssignedRole");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling getUserAssignedRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ListGroupAssignedRoles200ResponseInner> localVarReturnType = new TypeReference<ListGroupAssignedRoles200ResponseInner>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all User Role Assignments Lists all roles assigned to a User (identified by &#x60;userId&#x60;)
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param expand
     *            An optional parameter used to return targets configured for the standard Role Assignment in the
     *            &#x60;embedded&#x60; property. Supported values: &#x60;targets/groups&#x60; or
     *            &#x60;targets/catalog/apps&#x60; (optional)
     *
     * @return List&lt;ListGroupAssignedRoles200ResponseInner&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ListGroupAssignedRoles200ResponseInner> listAssignedRolesForUser(String userId, String expand)
            throws ApiException {
        return this.listAssignedRolesForUser(userId, expand, Collections.emptyMap());
    }

    /**
     * List all User Role Assignments Lists all roles assigned to a User (identified by &#x60;userId&#x60;)
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param expand
     *            An optional parameter used to return targets configured for the standard Role Assignment in the
     *            &#x60;embedded&#x60; property. Supported values: &#x60;targets/groups&#x60; or
     *            &#x60;targets/catalog/apps&#x60; (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;ListGroupAssignedRoles200ResponseInner&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ListGroupAssignedRoles200ResponseInner> listAssignedRolesForUser(String userId, String expand,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling listAssignedRolesForUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("expand", expand));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<ListGroupAssignedRoles200ResponseInner>> localVarReturnType = new TypeReference<List<ListGroupAssignedRoles200ResponseInner>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Users with Role Assignments Lists all users with Role Assignments
     *
     * @param after
     *            Specifies the pagination cursor for the next page of targets (optional)
     * @param limit
     *            Specifies the number of results returned. Defaults to &#x60;100&#x60;. (optional, default to 100)
     *
     * @return RoleAssignedUsers
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RoleAssignedUsers listUsersWithRoleAssignments(String after, Integer limit) throws ApiException {
        return this.listUsersWithRoleAssignments(after, limit, Collections.emptyMap());
    }

    /**
     * List all Users with Role Assignments Lists all users with Role Assignments
     *
     * @param after
     *            Specifies the pagination cursor for the next page of targets (optional)
     * @param limit
     *            Specifies the number of results returned. Defaults to &#x60;100&#x60;. (optional, default to 100)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return RoleAssignedUsers
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public RoleAssignedUsers listUsersWithRoleAssignments(String after, Integer limit,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/iam/assignees/users";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<RoleAssignedUsers> localVarReturnType = new TypeReference<RoleAssignedUsers>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Unassign a User Role Unassigns a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) from a User
     * (identified by &#x60;userId&#x60;)
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignRoleFromUser(String userId, String roleAssignmentId) throws ApiException {
        this.unassignRoleFromUser(userId, roleAssignmentId, Collections.emptyMap());
    }

    /**
     * Unassign a User Role Unassigns a Role Assignment (identified by &#x60;roleAssignmentId&#x60;) from a User
     * (identified by &#x60;userId&#x60;)
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param roleAssignmentId
     *            The &#x60;id&#x60; of the Role Assignment (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unassignRoleFromUser(String userId, String roleAssignmentId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unassignRoleFromUser");
        }

        // verify the required parameter 'roleAssignmentId' is set
        if (roleAssignmentId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleAssignmentId' when calling unassignRoleFromUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}"
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()))
                .replaceAll("\\{" + "roleAssignmentId" + "\\}", apiClient.escapeString(roleAssignmentId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
