/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.LogStream;
import com.okta.sdk.resource.model.LogStreamPutSchema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LogStreamApi {

    private ApiClient apiClient;

    public LogStreamApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogStreamApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate a Log Stream Activates a log stream by &#x60;logStreamId&#x60;
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream activateLogStream(String logStreamId) throws ApiException {
        return this.activateLogStream(logStreamId, Collections.emptyMap());
    }

    /**
     * Activate a Log Stream Activates a log stream by &#x60;logStreamId&#x60;
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream activateLogStream(String logStreamId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'logStreamId' is set
        if (logStreamId == null) {
            throw new ApiException(400, "Missing the required parameter 'logStreamId' when calling activateLogStream");
        }

        // create path and map variables
        String localVarPath = "/api/v1/logStreams/{logStreamId}/lifecycle/activate"
                .replaceAll("\\{" + "logStreamId" + "\\}", apiClient.escapeString(logStreamId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a Log Stream Creates a new Log Stream object
     *
     * @param instance
     *            (required)
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream createLogStream(LogStream instance) throws ApiException {
        return this.createLogStream(instance, Collections.emptyMap());
    }

    /**
     * Create a Log Stream Creates a new Log Stream object
     *
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream createLogStream(LogStream instance, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createLogStream");
        }

        // create path and map variables
        String localVarPath = "/api/v1/logStreams";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate a Log Stream Deactivates a log stream by &#x60;logStreamId&#x60;
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream deactivateLogStream(String logStreamId) throws ApiException {
        return this.deactivateLogStream(logStreamId, Collections.emptyMap());
    }

    /**
     * Deactivate a Log Stream Deactivates a log stream by &#x60;logStreamId&#x60;
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream deactivateLogStream(String logStreamId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'logStreamId' is set
        if (logStreamId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'logStreamId' when calling deactivateLogStream");
        }

        // create path and map variables
        String localVarPath = "/api/v1/logStreams/{logStreamId}/lifecycle/deactivate"
                .replaceAll("\\{" + "logStreamId" + "\\}", apiClient.escapeString(logStreamId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Delete a Log Stream Deletes a Log Stream object from your org by ID
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteLogStream(String logStreamId) throws ApiException {
        this.deleteLogStream(logStreamId, Collections.emptyMap());
    }

    /**
     * Delete a Log Stream Deletes a Log Stream object from your org by ID
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteLogStream(String logStreamId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'logStreamId' is set
        if (logStreamId == null) {
            throw new ApiException(400, "Missing the required parameter 'logStreamId' when calling deleteLogStream");
        }

        // create path and map variables
        String localVarPath = "/api/v1/logStreams/{logStreamId}".replaceAll("\\{" + "logStreamId" + "\\}",
                apiClient.escapeString(logStreamId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Log Stream Retrieves a Log Stream object by ID
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream getLogStream(String logStreamId) throws ApiException {
        return this.getLogStream(logStreamId, Collections.emptyMap());
    }

    /**
     * Retrieve a Log Stream Retrieves a Log Stream object by ID
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream getLogStream(String logStreamId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'logStreamId' is set
        if (logStreamId == null) {
            throw new ApiException(400, "Missing the required parameter 'logStreamId' when calling getLogStream");
        }

        // create path and map variables
        String localVarPath = "/api/v1/logStreams/{logStreamId}".replaceAll("\\{" + "logStreamId" + "\\}",
                apiClient.escapeString(logStreamId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Log Streams Lists all Log Stream objects in your org. You can request a paginated list or a subset of
     * Log Streams that match a supported filter expression.
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param filter
     *            An expression that [filters](/#filter) the returned objects. You can only use the &#x60;eq&#x60;
     *            operator on either the &#x60;status&#x60; or &#x60;type&#x60; properties in the filter expression.
     *            (optional)
     *
     * @return List&lt;LogStream&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<LogStream> listLogStreams(String after, Integer limit, String filter) throws ApiException {
        return this.listLogStreams(after, limit, filter, Collections.emptyMap());
    }

    /**
     * List all Log Streams Lists all Log Stream objects in your org. You can request a paginated list or a subset of
     * Log Streams that match a supported filter expression.
     *
     * @param after
     *            The cursor to use for pagination. It is an opaque string that specifies your current location in the
     *            list and is obtained from the &#x60;Link&#x60; response header. See
     *            [Pagination](https://developer.okta.com/docs/api/#pagination). (optional)
     * @param limit
     *            A limit on the number of objects to return (optional, default to 20)
     * @param filter
     *            An expression that [filters](/#filter) the returned objects. You can only use the &#x60;eq&#x60;
     *            operator on either the &#x60;status&#x60; or &#x60;type&#x60; properties in the filter expression.
     *            (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;LogStream&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<LogStream> listLogStreams(String after, Integer limit, String filter,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/logStreams";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<LogStream>> localVarReturnType = new TypeReference<List<LogStream>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Log Stream Replaces the Log Stream object properties for a given ID. This operation is typically used
     * to update the configuration of a Log Stream. Depending on the type of Log Stream you want to update, certain
     * properties can&#39;t be modified after the Log Stream is initially created. Use the [Retrieve the Log Stream
     * Schema for the schema
     * type](/openapi/okta-management/management/tag/Schema/#tag/Schema/operation/getLogStreamSchema) request to
     * determine which properties you can update for the specific Log Stream type. Log Stream properties with the
     * &#x60;\&quot;writeOnce\&quot; : true&#x60; attribute can&#39;t be updated after creation. You must still specify
     * these &#x60;writeOnce&#x60; properties in the request body with the original values in the PUT request. &gt;
     * **Note:** You don&#39;t have to specify properties that have both the &#x60;\&quot;writeOnce\&quot;: true&#x60;
     * and the &#x60;\&quot;writeOnly\&quot;: true&#x60; attributes in the PUT request body. These property values are
     * ignored even if you add them in the PUT request body.
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     * @param instance
     *            (required)
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream replaceLogStream(String logStreamId, LogStreamPutSchema instance) throws ApiException {
        return this.replaceLogStream(logStreamId, instance, Collections.emptyMap());
    }

    /**
     * Replace a Log Stream Replaces the Log Stream object properties for a given ID. This operation is typically used
     * to update the configuration of a Log Stream. Depending on the type of Log Stream you want to update, certain
     * properties can&#39;t be modified after the Log Stream is initially created. Use the [Retrieve the Log Stream
     * Schema for the schema
     * type](/openapi/okta-management/management/tag/Schema/#tag/Schema/operation/getLogStreamSchema) request to
     * determine which properties you can update for the specific Log Stream type. Log Stream properties with the
     * &#x60;\&quot;writeOnce\&quot; : true&#x60; attribute can&#39;t be updated after creation. You must still specify
     * these &#x60;writeOnce&#x60; properties in the request body with the original values in the PUT request. &gt;
     * **Note:** You don&#39;t have to specify properties that have both the &#x60;\&quot;writeOnce\&quot;: true&#x60;
     * and the &#x60;\&quot;writeOnly\&quot;: true&#x60; attributes in the PUT request body. These property values are
     * ignored even if you add them in the PUT request body.
     *
     * @param logStreamId
     *            Unique identifier for the Log Stream (required)
     * @param instance
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return LogStream
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public LogStream replaceLogStream(String logStreamId, LogStreamPutSchema instance,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = instance;

        // verify the required parameter 'logStreamId' is set
        if (logStreamId == null) {
            throw new ApiException(400, "Missing the required parameter 'logStreamId' when calling replaceLogStream");
        }

        // verify the required parameter 'instance' is set
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling replaceLogStream");
        }

        // create path and map variables
        String localVarPath = "/api/v1/logStreams/{logStreamId}".replaceAll("\\{" + "logStreamId" + "\\}",
                apiClient.escapeString(logStreamId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
