/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.DesktopMFARecoveryPinOrgSetting;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class DeviceAccessApi {

    private ApiClient apiClient;

    public DeviceAccessApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceAccessApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve the Desktop MFA Recovery PIN Org setting Retrieves the status of the Desktop MFA Recovery PIN feature.
     * That is, whether or not the feature is enabled for your org.
     *
     * @return DesktopMFARecoveryPinOrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DesktopMFARecoveryPinOrgSetting getDesktopMFARecoveryPinOrgSetting() throws ApiException {
        return this.getDesktopMFARecoveryPinOrgSetting(Collections.emptyMap());
    }

    /**
     * Retrieve the Desktop MFA Recovery PIN Org setting Retrieves the status of the Desktop MFA Recovery PIN feature.
     * That is, whether or not the feature is enabled for your org.
     *
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DesktopMFARecoveryPinOrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DesktopMFARecoveryPinOrgSetting getDesktopMFARecoveryPinOrgSetting(Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/device-access/api/v1/desktop-mfa/recovery-pin-settings";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DesktopMFARecoveryPinOrgSetting> localVarReturnType = new TypeReference<DesktopMFARecoveryPinOrgSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace the Desktop MFA Recovery PIN Org Setting Replaces the Desktop MFA Recovery PIN feature for your org
     *
     * @param desktopMFARecoveryPinOrgSetting
     *            (required)
     *
     * @return DesktopMFARecoveryPinOrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DesktopMFARecoveryPinOrgSetting replaceDesktopMFARecoveryPinOrgSetting(
            DesktopMFARecoveryPinOrgSetting desktopMFARecoveryPinOrgSetting) throws ApiException {
        return this.replaceDesktopMFARecoveryPinOrgSetting(desktopMFARecoveryPinOrgSetting, Collections.emptyMap());
    }

    /**
     * Replace the Desktop MFA Recovery PIN Org Setting Replaces the Desktop MFA Recovery PIN feature for your org
     *
     * @param desktopMFARecoveryPinOrgSetting
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return DesktopMFARecoveryPinOrgSetting
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public DesktopMFARecoveryPinOrgSetting replaceDesktopMFARecoveryPinOrgSetting(
            DesktopMFARecoveryPinOrgSetting desktopMFARecoveryPinOrgSetting, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = desktopMFARecoveryPinOrgSetting;

        // verify the required parameter 'desktopMFARecoveryPinOrgSetting' is set
        if (desktopMFARecoveryPinOrgSetting == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'desktopMFARecoveryPinOrgSetting' when calling replaceDesktopMFARecoveryPinOrgSetting");
        }

        // create path and map variables
        String localVarPath = "/device-access/api/v1/desktop-mfa/recovery-pin-settings";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<DesktopMFARecoveryPinOrgSetting> localVarReturnType = new TypeReference<DesktopMFARecoveryPinOrgSetting>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
