/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ECKeyJWK;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Enrollment Initialization Request")
@JsonPropertyOrder(value={"enrollmentRpIds", "fulfillmentProvider", "userId", "yubicoTransportKeyJWK"})
public class EnrollmentInitializationRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ENROLLMENT_RP_IDS = "enrollmentRpIds";
    private List<String> enrollmentRpIds = null;
    public static final String JSON_PROPERTY_FULFILLMENT_PROVIDER = "fulfillmentProvider";
    private FulfillmentProviderEnum fulfillmentProvider;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_YUBICO_TRANSPORT_KEY_J_W_K = "yubicoTransportKeyJWK";
    private ECKeyJWK yubicoTransportKeyJWK;

    public EnrollmentInitializationRequest enrollmentRpIds(List<String> enrollmentRpIds) {
        this.enrollmentRpIds = enrollmentRpIds;
        return this;
    }

    public EnrollmentInitializationRequest addenrollmentRpIdsItem(String enrollmentRpIdsItem) {
        if (this.enrollmentRpIds == null) {
            this.enrollmentRpIds = new ArrayList<String>();
        }
        this.enrollmentRpIds.add(enrollmentRpIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of Relying Party hostnames to register on the YubiKey.")
    @JsonProperty(value="enrollmentRpIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getEnrollmentRpIds() {
        return this.enrollmentRpIds;
    }

    @JsonProperty(value="enrollmentRpIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnrollmentRpIds(List<String> enrollmentRpIds) {
        this.enrollmentRpIds = enrollmentRpIds;
    }

    public EnrollmentInitializationRequest fulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the fulfillment provider for the WebAuthn Preregistration Factor")
    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FulfillmentProviderEnum getFulfillmentProvider() {
        return this.fulfillmentProvider;
    }

    @JsonProperty(value="fulfillmentProvider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFulfillmentProvider(FulfillmentProviderEnum fulfillmentProvider) {
        this.fulfillmentProvider = fulfillmentProvider;
    }

    public EnrollmentInitializationRequest userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of an existing Okta user")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public EnrollmentInitializationRequest yubicoTransportKeyJWK(ECKeyJWK yubicoTransportKeyJWK) {
        this.yubicoTransportKeyJWK = yubicoTransportKeyJWK;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="yubicoTransportKeyJWK")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ECKeyJWK getYubicoTransportKeyJWK() {
        return this.yubicoTransportKeyJWK;
    }

    @JsonProperty(value="yubicoTransportKeyJWK")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setYubicoTransportKeyJWK(ECKeyJWK yubicoTransportKeyJWK) {
        this.yubicoTransportKeyJWK = yubicoTransportKeyJWK;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnrollmentInitializationRequest enrollmentInitializationRequest = (EnrollmentInitializationRequest)o;
        return Objects.equals(this.enrollmentRpIds, enrollmentInitializationRequest.enrollmentRpIds) && Objects.equals((Object)this.fulfillmentProvider, (Object)enrollmentInitializationRequest.fulfillmentProvider) && Objects.equals(this.userId, enrollmentInitializationRequest.userId) && Objects.equals(this.yubicoTransportKeyJWK, enrollmentInitializationRequest.yubicoTransportKeyJWK);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enrollmentRpIds, this.fulfillmentProvider, this.userId, this.yubicoTransportKeyJWK});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnrollmentInitializationRequest {\n");
        sb.append("    enrollmentRpIds: ").append(this.toIndentedString(this.enrollmentRpIds)).append("\n");
        sb.append("    fulfillmentProvider: ").append(this.toIndentedString((Object)this.fulfillmentProvider)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    yubicoTransportKeyJWK: ").append(this.toIndentedString(this.yubicoTransportKeyJWK)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FulfillmentProviderEnum {
        YUBICO(String.valueOf("yubico")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FulfillmentProviderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FulfillmentProviderEnum fromValue(String value) {
            for (FulfillmentProviderEnum b : FulfillmentProviderEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

