/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.DeviceChecksPlatform;
import com.okta.sdk.resource.model.LinksSelf;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"createdBy", "createdDate", "description", "id", "lastUpdate", "lastUpdatedBy", "name", "platform", "query", "variableName", "_links"})
public class DeviceCheck
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private String createdBy;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private String createdDate;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATE = "lastUpdate";
    private String lastUpdate;
    public static final String JSON_PROPERTY_LAST_UPDATED_BY = "lastUpdatedBy";
    private String lastUpdatedBy;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private DeviceChecksPlatform platform;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_VARIABLE_NAME = "variableName";
    private String variableName;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    @Nullable
    @ApiModelProperty(example="00u217pyf72CdUrBt1c5", value="User who created the Device Check")
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Nullable
    @ApiModelProperty(example="2019-10-02T18:03:07.000Z", value="Time the Device Check was created")
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreatedDate() {
        return this.createdDate;
    }

    public DeviceCheck description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Query macOS devices to check if firewall is enabled", value="Description of the Device Check")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    @ApiModelProperty(example="dch3m8o4rWhwReDeM1c5", value="The ID of the Device Check")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2019-10-02T18:03:07.000Z", value="Time the Device Check was updated")
    @JsonProperty(value="lastUpdate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdate() {
        return this.lastUpdate;
    }

    @Nullable
    @ApiModelProperty(example="00u217pyf72CdUrBt1c5", value="User who updated the Device Check")
    @JsonProperty(value="lastUpdatedBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public DeviceCheck name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Device Check macOS", value="Display name of the Device Check")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public DeviceCheck platform(DeviceChecksPlatform platform) {
        this.platform = platform;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeviceChecksPlatform getPlatform() {
        return this.platform;
    }

    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatform(DeviceChecksPlatform platform) {
        this.platform = platform;
    }

    public DeviceCheck query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SELECT CASE WHEN global_state = 0 THEN 0 ELSE 1 END AS firewall_enabled FROM  alf;", value="OSQuery for the Device Check")
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuery(String query) {
        this.query = query;
    }

    public DeviceCheck variableName(String variableName) {
        this.variableName = variableName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="macOSFirewall", value="Unique name of the Device Check")
    @JsonProperty(value="variableName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVariableName() {
        return this.variableName;
    }

    @JsonProperty(value="variableName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public DeviceCheck links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceCheck deviceCheck = (DeviceCheck)o;
        return Objects.equals(this.createdBy, deviceCheck.createdBy) && Objects.equals(this.createdDate, deviceCheck.createdDate) && Objects.equals(this.description, deviceCheck.description) && Objects.equals(this.id, deviceCheck.id) && Objects.equals(this.lastUpdate, deviceCheck.lastUpdate) && Objects.equals(this.lastUpdatedBy, deviceCheck.lastUpdatedBy) && Objects.equals(this.name, deviceCheck.name) && Objects.equals((Object)this.platform, (Object)deviceCheck.platform) && Objects.equals(this.query, deviceCheck.query) && Objects.equals(this.variableName, deviceCheck.variableName) && Objects.equals(this.links, deviceCheck.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdBy, this.createdDate, this.description, this.id, this.lastUpdate, this.lastUpdatedBy, this.name, this.platform, this.query, this.variableName, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceCheck {\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    lastUpdatedBy: ").append(this.toIndentedString(this.lastUpdatedBy)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString((Object)this.platform)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    variableName: ").append(this.toIndentedString(this.variableName)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

