/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Information used to generate the secret JSON Web Token for the token requests to Apple IdP > **Note:** The `privateKey` property is required for a CREATE request. For an UPDATE request, it can be null and keeps the existing value if it's null. The `privateKey` property isn't returned for LIST and GET requests or UPDATE requests if it's null.")
@JsonPropertyOrder(value={"kid", "privateKey", "teamId"})
public class AppleClientSigning
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_PRIVATE_KEY = "privateKey";
    private String privateKey;
    public static final String JSON_PROPERTY_TEAM_ID = "teamId";
    private String teamId;

    public AppleClientSigning kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="test key id", value="The Key ID that you obtained from Apple when you created the private key for the client")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public AppleClientSigning privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="MIGTAgEAMBM........Cb9PnybCnzDv+3cWSGWqpAIsQQZ", value="The PKCS \\#8 encoded private key that you created for the client and downloaded from Apple")
    @JsonProperty(value="privateKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrivateKey() {
        return this.privateKey;
    }

    @JsonProperty(value="privateKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public AppleClientSigning teamId(String teamId) {
        this.teamId = teamId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="test team id", value="The Team ID associated with your Apple developer account")
    @JsonProperty(value="teamId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTeamId() {
        return this.teamId;
    }

    @JsonProperty(value="teamId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTeamId(String teamId) {
        this.teamId = teamId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppleClientSigning appleClientSigning = (AppleClientSigning)o;
        return Objects.equals(this.kid, appleClientSigning.kid) && Objects.equals(this.privateKey, appleClientSigning.privateKey) && Objects.equals(this.teamId, appleClientSigning.teamId);
    }

    public int hashCode() {
        return Objects.hash(this.kid, this.privateKey, this.teamId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppleClientSigning {\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    teamId: ").append(this.toIndentedString(this.teamId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

