/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The Public Key Details are defined in the `_embedded` property of the Key object.")
@JsonPropertyOrder(value={"alg", "e", "kid", "kty", "n", "use"})
@JsonTypeName(value="_embedded")
public class Embedded
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;
    public static final String JSON_PROPERTY_N = "n";
    private String n;
    public static final String JSON_PROPERTY_USE = "use";
    private JsonNullable<String> use = JsonNullable.undefined();

    @Nullable
    @ApiModelProperty(value="Algorithm used in the key")
    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlg() {
        return this.alg;
    }

    @Nullable
    @ApiModelProperty(value="RSA key value (exponent) for key binding")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getE() {
        return this.e;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the certificate")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @Nullable
    @ApiModelProperty(value="Cryptographic algorithm family for the certificate's keypair")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKty() {
        return this.kty;
    }

    @Nullable
    @ApiModelProperty(value="RSA key value (modulus) for key binding")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getN() {
        return this.n;
    }

    @Nullable
    @ApiModelProperty(value="Acceptable use of the certificate")
    @JsonIgnore
    public String getUse() {
        if (this.use == null) {
            this.use = JsonNullable.undefined();
        }
        return (String)this.use.orElse(null);
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getUse_JsonNullable() {
        return this.use;
    }

    @JsonProperty(value="use")
    private void setUse_JsonNullable(JsonNullable<String> use) {
        this.use = use;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Embedded embedded = (Embedded)o;
        return Objects.equals(this.alg, embedded.alg) && Objects.equals(this.e, embedded.e) && Objects.equals(this.kid, embedded.kid) && Objects.equals(this.kty, embedded.kty) && Objects.equals(this.n, embedded.n) && Embedded.equalsNullable(this.use, embedded.use);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.e, this.kid, this.kty, this.n, Embedded.hashCodeNullable(this.use));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Embedded {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString(this.kty)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    use: ").append(this.toIndentedString(this.use)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

