/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Contains information about the intended SET delivery method by the receiver")
@JsonPropertyOrder(value={"authorization_header", "endpoint_url", "method"})
public class StreamConfigurationDelivery
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHORIZATION_HEADER = "authorization_header";
    private JsonNullable<String> authorizationHeader = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ENDPOINT_URL = "endpoint_url";
    private URI endpointUrl;
    public static final String JSON_PROPERTY_METHOD = "method";
    private MethodEnum method;

    public StreamConfigurationDelivery authorizationHeader(String authorizationHeader) {
        this.authorizationHeader = JsonNullable.of((Object)authorizationHeader);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="{authorizationHeaderValue}", value="The HTTP Authorization header that is included for each HTTP POST request")
    @JsonIgnore
    public String getAuthorizationHeader() {
        return (String)this.authorizationHeader.orElse(null);
    }

    @JsonProperty(value="authorization_header")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAuthorizationHeader_JsonNullable() {
        return this.authorizationHeader;
    }

    @JsonProperty(value="authorization_header")
    public void setAuthorizationHeader_JsonNullable(JsonNullable<String> authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = JsonNullable.of((Object)authorizationHeader);
    }

    public StreamConfigurationDelivery endpointUrl(URI endpointUrl) {
        this.endpointUrl = endpointUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.com/", required=true, value="The target endpoint URL where the transmitter delivers the SET using HTTP POST requests")
    @JsonProperty(value="endpoint_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getEndpointUrl() {
        return this.endpointUrl;
    }

    @JsonProperty(value="endpoint_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEndpointUrl(URI endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public StreamConfigurationDelivery method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The delivery method that the transmitter uses for delivering a SET")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MethodEnum getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamConfigurationDelivery streamConfigurationDelivery = (StreamConfigurationDelivery)o;
        return StreamConfigurationDelivery.equalsNullable(this.authorizationHeader, streamConfigurationDelivery.authorizationHeader) && Objects.equals(this.endpointUrl, streamConfigurationDelivery.endpointUrl) && Objects.equals((Object)this.method, (Object)streamConfigurationDelivery.method);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{StreamConfigurationDelivery.hashCodeNullable(this.authorizationHeader), this.endpointUrl, this.method});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StreamConfigurationDelivery {\n");
        sb.append("    authorizationHeader: ").append(this.toIndentedString(this.authorizationHeader)).append("\n");
        sb.append("    endpointUrl: ").append(this.toIndentedString(this.endpointUrl)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MethodEnum {
        HTTPS_SCHEMAS_OPENID_NET_SECEVENT_RISC_DELIVERY_METHOD_PUSH(String.valueOf("https://schemas.openid.net/secevent/risc/delivery-method/push")),
        URN_IETF_RFC_8935(String.valueOf("urn:ietf:rfc:8935")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

