/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.IdentityProvider;
import com.okta.sdk.resource.model.IdentityProviderApplicationUser;
import com.okta.sdk.resource.model.SocialAuthToken;
import com.okta.sdk.resource.model.UserIdentityProviderLinkRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class IdentityProviderUsersApi {
    private ApiClient apiClient;

    public IdentityProviderUsersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IdentityProviderUsersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public IdentityProviderApplicationUser getIdentityProviderApplicationUser(String idpId, String userId) throws ApiException {
        return this.getIdentityProviderApplicationUser(idpId, userId, Collections.emptyMap());
    }

    public IdentityProviderApplicationUser getIdentityProviderApplicationUser(String idpId, String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling getIdentityProviderApplicationUser");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getIdentityProviderApplicationUser");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentityProviderApplicationUser> localVarReturnType = new TypeReference<IdentityProviderApplicationUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public IdentityProviderApplicationUser linkUserToIdentityProvider(String idpId, String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest) throws ApiException {
        return this.linkUserToIdentityProvider(idpId, userId, userIdentityProviderLinkRequest, Collections.emptyMap());
    }

    public IdentityProviderApplicationUser linkUserToIdentityProvider(String idpId, String userId, UserIdentityProviderLinkRequest userIdentityProviderLinkRequest, Map<String, String> additionalHeaders) throws ApiException {
        UserIdentityProviderLinkRequest localVarPostBody = userIdentityProviderLinkRequest;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling linkUserToIdentityProvider");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling linkUserToIdentityProvider");
        }
        if (userIdentityProviderLinkRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'userIdentityProviderLinkRequest' when calling linkUserToIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<IdentityProviderApplicationUser> localVarReturnType = new TypeReference<IdentityProviderApplicationUser>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IdentityProviderApplicationUser> listIdentityProviderApplicationUsers(String idpId, String q, String after, Integer limit, String expand) throws ApiException {
        return this.listIdentityProviderApplicationUsers(idpId, q, after, limit, expand, Collections.emptyMap());
    }

    public List<IdentityProviderApplicationUser> listIdentityProviderApplicationUsers(String idpId, String q, String after, Integer limit, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listIdentityProviderApplicationUsers");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdentityProviderApplicationUser>> localVarReturnType = new TypeReference<List<IdentityProviderApplicationUser>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<SocialAuthToken> listSocialAuthTokens(String idpId, String userId) throws ApiException {
        return this.listSocialAuthTokens(idpId, userId, Collections.emptyMap());
    }

    public List<SocialAuthToken> listSocialAuthTokens(String idpId, String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling listSocialAuthTokens");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSocialAuthTokens");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}/credentials/tokens".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<SocialAuthToken>> localVarReturnType = new TypeReference<List<SocialAuthToken>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<IdentityProvider> listUserIdentityProviders(String userId) throws ApiException {
        return this.listUserIdentityProviders(userId, Collections.emptyMap());
    }

    public List<IdentityProvider> listUserIdentityProviders(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserIdentityProviders");
        }
        String localVarPath = "/api/v1/users/{userId}/idps".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<IdentityProvider>> localVarReturnType = new TypeReference<List<IdentityProvider>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unlinkUserFromIdentityProvider(String idpId, String userId) throws ApiException {
        this.unlinkUserFromIdentityProvider(idpId, userId, Collections.emptyMap());
    }

    public void unlinkUserFromIdentityProvider(String idpId, String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (idpId == null) {
            throw new ApiException(400, "Missing the required parameter 'idpId' when calling unlinkUserFromIdentityProvider");
        }
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unlinkUserFromIdentityProvider");
        }
        String localVarPath = "/api/v1/idps/{idpId}/users/{userId}".replaceAll("\\{idpId\\}", this.apiClient.escapeString(idpId.toString())).replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

