/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Determines if the app participates in Single Logout (SLO)")
@JsonPropertyOrder(value={"bindingType", "enabled", "logoutRequestUrl", "sessionIndexRequired"})
public class SloParticipate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_BINDING_TYPE = "bindingType";
    private BindingTypeEnum bindingType;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;
    public static final String JSON_PROPERTY_LOGOUT_REQUEST_URL = "logoutRequestUrl";
    private String logoutRequestUrl;
    public static final String JSON_PROPERTY_SESSION_INDEX_REQUIRED = "sessionIndexRequired";
    private Boolean sessionIndexRequired;

    public SloParticipate bindingType(BindingTypeEnum bindingType) {
        this.bindingType = bindingType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Request binding type")
    @JsonProperty(value="bindingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BindingTypeEnum getBindingType() {
        return this.bindingType;
    }

    @JsonProperty(value="bindingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBindingType(BindingTypeEnum bindingType) {
        this.bindingType = bindingType;
    }

    public SloParticipate enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates whether the app is allowed to participate in front-channel SLO")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public SloParticipate logoutRequestUrl(String logoutRequestUrl) {
        this.logoutRequestUrl = logoutRequestUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL where Okta sends the logout request")
    @JsonProperty(value="logoutRequestUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLogoutRequestUrl() {
        return this.logoutRequestUrl;
    }

    @JsonProperty(value="logoutRequestUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLogoutRequestUrl(String logoutRequestUrl) {
        this.logoutRequestUrl = logoutRequestUrl;
    }

    public SloParticipate sessionIndexRequired(Boolean sessionIndexRequired) {
        this.sessionIndexRequired = sessionIndexRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines whether Okta sends the `SessionIndex` elements in the logout request")
    @JsonProperty(value="sessionIndexRequired")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSessionIndexRequired() {
        return this.sessionIndexRequired;
    }

    @JsonProperty(value="sessionIndexRequired")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSessionIndexRequired(Boolean sessionIndexRequired) {
        this.sessionIndexRequired = sessionIndexRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SloParticipate sloParticipate = (SloParticipate)o;
        return Objects.equals((Object)this.bindingType, (Object)sloParticipate.bindingType) && Objects.equals(this.enabled, sloParticipate.enabled) && Objects.equals(this.logoutRequestUrl, sloParticipate.logoutRequestUrl) && Objects.equals(this.sessionIndexRequired, sloParticipate.sessionIndexRequired);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bindingType, this.enabled, this.logoutRequestUrl, this.sessionIndexRequired});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SloParticipate {\n");
        sb.append("    bindingType: ").append(this.toIndentedString((Object)this.bindingType)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    logoutRequestUrl: ").append(this.toIndentedString(this.logoutRequestUrl)).append("\n");
        sb.append("    sessionIndexRequired: ").append(this.toIndentedString(this.sessionIndexRequired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum BindingTypeEnum {
        POST("POST"),
        REDIRECT("REDIRECT"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private BindingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BindingTypeEnum fromValue(String value) {
            for (BindingTypeEnum b : BindingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

