/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonAdmin;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonUser;
import com.okta.sdk.resource.model.SecurityEventSubject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The session of the subject was revoked")
@JsonPropertyOrder(value={"current_ip", "current_user_agent", "event_timestamp", "initiating_entity", "last_known_ip", "last_known_user_agent", "reason_admin", "reason_user", "subject"})
public class CaepSessionRevokedEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CURRENT_IP = "current_ip";
    private String currentIp;
    public static final String JSON_PROPERTY_CURRENT_USER_AGENT = "current_user_agent";
    private String currentUserAgent;
    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;
    public static final String JSON_PROPERTY_INITIATING_ENTITY = "initiating_entity";
    private InitiatingEntityEnum initiatingEntity;
    public static final String JSON_PROPERTY_LAST_KNOWN_IP = "last_known_ip";
    private String lastKnownIp;
    public static final String JSON_PROPERTY_LAST_KNOWN_USER_AGENT = "last_known_user_agent";
    private String lastKnownUserAgent;
    public static final String JSON_PROPERTY_REASON_ADMIN = "reason_admin";
    private CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin;
    public static final String JSON_PROPERTY_REASON_USER = "reason_user";
    private CaepDeviceComplianceChangeEventReasonUser reasonUser;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SecurityEventSubject subject;

    public CaepSessionRevokedEvent currentIp(String currentIp) {
        this.currentIp = currentIp;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123.4.5.6", value="Current IP of the session")
    @JsonProperty(value="current_ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrentIp() {
        return this.currentIp;
    }

    @JsonProperty(value="current_ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrentIp(String currentIp) {
        this.currentIp = currentIp;
    }

    public CaepSessionRevokedEvent currentUserAgent(String currentUserAgent) {
        this.currentUserAgent = currentUserAgent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="CurrentUserAgent", value="Current User Agent of the session")
    @JsonProperty(value="current_user_agent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCurrentUserAgent() {
        return this.currentUserAgent;
    }

    @JsonProperty(value="current_user_agent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrentUserAgent(String currentUserAgent) {
        this.currentUserAgent = currentUserAgent;
    }

    public CaepSessionRevokedEvent eventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1702448550", required=true, value="The time of the event (UNIX timestamp)")
    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getEventTimestamp() {
        return this.eventTimestamp;
    }

    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public CaepSessionRevokedEvent initiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The entity that initiated the event")
    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InitiatingEntityEnum getInitiatingEntity() {
        return this.initiatingEntity;
    }

    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
    }

    public CaepSessionRevokedEvent lastKnownIp(String lastKnownIp) {
        this.lastKnownIp = lastKnownIp;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123.4.5.6", value="Last known IP of the session")
    @JsonProperty(value="last_known_ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastKnownIp() {
        return this.lastKnownIp;
    }

    @JsonProperty(value="last_known_ip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastKnownIp(String lastKnownIp) {
        this.lastKnownIp = lastKnownIp;
    }

    public CaepSessionRevokedEvent lastKnownUserAgent(String lastKnownUserAgent) {
        this.lastKnownUserAgent = lastKnownUserAgent;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="LastUserAgent", value="Last known User Agent of the session")
    @JsonProperty(value="last_known_user_agent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastKnownUserAgent() {
        return this.lastKnownUserAgent;
    }

    @JsonProperty(value="last_known_user_agent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastKnownUserAgent(String lastKnownUserAgent) {
        this.lastKnownUserAgent = lastKnownUserAgent;
    }

    public CaepSessionRevokedEvent reasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepDeviceComplianceChangeEventReasonAdmin getReasonAdmin() {
        return this.reasonAdmin;
    }

    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
    }

    public CaepSessionRevokedEvent reasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepDeviceComplianceChangeEventReasonUser getReasonUser() {
        return this.reasonUser;
    }

    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
    }

    public CaepSessionRevokedEvent subject(SecurityEventSubject subject) {
        this.subject = subject;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityEventSubject getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubject(SecurityEventSubject subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaepSessionRevokedEvent caepSessionRevokedEvent = (CaepSessionRevokedEvent)o;
        return Objects.equals(this.currentIp, caepSessionRevokedEvent.currentIp) && Objects.equals(this.currentUserAgent, caepSessionRevokedEvent.currentUserAgent) && Objects.equals(this.eventTimestamp, caepSessionRevokedEvent.eventTimestamp) && Objects.equals((Object)this.initiatingEntity, (Object)caepSessionRevokedEvent.initiatingEntity) && Objects.equals(this.lastKnownIp, caepSessionRevokedEvent.lastKnownIp) && Objects.equals(this.lastKnownUserAgent, caepSessionRevokedEvent.lastKnownUserAgent) && Objects.equals(this.reasonAdmin, caepSessionRevokedEvent.reasonAdmin) && Objects.equals(this.reasonUser, caepSessionRevokedEvent.reasonUser) && Objects.equals(this.subject, caepSessionRevokedEvent.subject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currentIp, this.currentUserAgent, this.eventTimestamp, this.initiatingEntity, this.lastKnownIp, this.lastKnownUserAgent, this.reasonAdmin, this.reasonUser, this.subject});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaepSessionRevokedEvent {\n");
        sb.append("    currentIp: ").append(this.toIndentedString(this.currentIp)).append("\n");
        sb.append("    currentUserAgent: ").append(this.toIndentedString(this.currentUserAgent)).append("\n");
        sb.append("    eventTimestamp: ").append(this.toIndentedString(this.eventTimestamp)).append("\n");
        sb.append("    initiatingEntity: ").append(this.toIndentedString((Object)this.initiatingEntity)).append("\n");
        sb.append("    lastKnownIp: ").append(this.toIndentedString(this.lastKnownIp)).append("\n");
        sb.append("    lastKnownUserAgent: ").append(this.toIndentedString(this.lastKnownUserAgent)).append("\n");
        sb.append("    reasonAdmin: ").append(this.toIndentedString(this.reasonAdmin)).append("\n");
        sb.append("    reasonUser: ").append(this.toIndentedString(this.reasonUser)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InitiatingEntityEnum {
        ADMIN("admin"),
        USER("user"),
        POLICY("policy"),
        SYSTEM("system"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private InitiatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InitiatingEntityEnum fromValue(String value) {
            for (InitiatingEntityEnum b : InitiatingEntityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

