/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="OIDC test details")
@JsonPropertyOrder(value={"idp", "sp", "jit", "spInitiateUrl"})
@JsonTypeName(value="TestInfo_oidcTestConfiguration")
public class TestInfoOidcTestConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_IDP = "idp";
    private Boolean idp;
    public static final String JSON_PROPERTY_SP = "sp";
    private Boolean sp;
    public static final String JSON_PROPERTY_JIT = "jit";
    private Boolean jit;
    public static final String JSON_PROPERTY_SP_INITIATE_URL = "spInitiateUrl";
    private URI spInitiateUrl;

    @Nullable
    @ApiModelProperty(value="Read only.<br>Indicates if your integration supports IdP-initiated sign-in flows. If [`sso.oidc.initiateLoginUri`](/openapi/okta-management/management/tag/YourOinIntegrations/#tag/YourOinIntegrations/operation/createSubmission!path=sso/oidc/initiateLoginUri&t=request) is specified, this property is set to `true`. If [`sso.oidc.initiateLoginUri`](/openapi/okta-management/management/tag/YourOinIntegrations/#tag/YourOinIntegrations/operation/createSubmission!path=sso/oidc/initiateLoginUri&t=request) isn't set for the integration submission, this property is set to `false`")
    @JsonProperty(value="idp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIdp() {
        return this.idp;
    }

    @Nullable
    @ApiModelProperty(value="Read only.<br>Indicates if your integration supports SP-initiated sign-in flows and is always set to `true` for OIDC SSO")
    @JsonProperty(value="sp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSp() {
        return this.sp;
    }

    public TestInfoOidcTestConfiguration jit(Boolean jit) {
        this.jit = jit;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if your integration supports Just-In-Time (JIT) provisioning")
    @JsonProperty(value="jit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getJit() {
        return this.jit;
    }

    @JsonProperty(value="jit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJit(Boolean jit) {
        this.jit = jit;
    }

    public TestInfoOidcTestConfiguration spInitiateUrl(URI spInitiateUrl) {
        this.spInitiateUrl = spInitiateUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://test.example.com/strawberry/oidc/sp-init", required=true, value="URL for SP-initiated sign-in flows (required if `sp = true`)")
    @JsonProperty(value="spInitiateUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getSpInitiateUrl() {
        return this.spInitiateUrl;
    }

    @JsonProperty(value="spInitiateUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSpInitiateUrl(URI spInitiateUrl) {
        this.spInitiateUrl = spInitiateUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestInfoOidcTestConfiguration testInfoOidcTestConfiguration = (TestInfoOidcTestConfiguration)o;
        return Objects.equals(this.idp, testInfoOidcTestConfiguration.idp) && Objects.equals(this.sp, testInfoOidcTestConfiguration.sp) && Objects.equals(this.jit, testInfoOidcTestConfiguration.jit) && Objects.equals(this.spInitiateUrl, testInfoOidcTestConfiguration.spInitiateUrl);
    }

    public int hashCode() {
        return Objects.hash(this.idp, this.sp, this.jit, this.spInitiateUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestInfoOidcTestConfiguration {\n");
        sb.append("    idp: ").append(this.toIndentedString(this.idp)).append("\n");
        sb.append("    sp: ").append(this.toIndentedString(this.sp)).append("\n");
        sb.append("    jit: ").append(this.toIndentedString(this.jit)).append("\n");
        sb.append("    spInitiateUrl: ").append(this.toIndentedString(this.spInitiateUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

