/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.SecurityEventsProviderRequestSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="The request schema for creating or updating a Security Events Provider. The `settings` must match one of the schemas.")
@JsonPropertyOrder(value={"name", "settings", "type"})
public class SecurityEventsProviderRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private SecurityEventsProviderRequestSettings settings;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public SecurityEventsProviderRequest name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Target SSF Provider", required=true, value="The name of the Security Events Provider instance")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public SecurityEventsProviderRequest settings(SecurityEventsProviderRequestSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityEventsProviderRequestSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSettings(SecurityEventsProviderRequestSettings settings) {
        this.settings = settings;
    }

    public SecurityEventsProviderRequest type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="okta", required=true, value="The application type of the Security Events Provider")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderRequest securityEventsProviderRequest = (SecurityEventsProviderRequest)o;
        return Objects.equals(this.name, securityEventsProviderRequest.name) && Objects.equals(this.settings, securityEventsProviderRequest.settings) && Objects.equals(this.type, securityEventsProviderRequest.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.settings, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

