/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OSVersionConstraintDynamicVersionRequirement;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"dynamicVersionRequirement", "majorVersionConstraint", "minimum"})
public class OSVersionConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT = "dynamicVersionRequirement";
    private OSVersionConstraintDynamicVersionRequirement dynamicVersionRequirement;
    public static final String JSON_PROPERTY_MAJOR_VERSION_CONSTRAINT = "majorVersionConstraint";
    private MajorVersionConstraintEnum majorVersionConstraint;
    public static final String JSON_PROPERTY_MINIMUM = "minimum";
    private String minimum;

    public OSVersionConstraint dynamicVersionRequirement(OSVersionConstraintDynamicVersionRequirement dynamicVersionRequirement) {
        this.dynamicVersionRequirement = dynamicVersionRequirement;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="dynamicVersionRequirement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OSVersionConstraintDynamicVersionRequirement getDynamicVersionRequirement() {
        return this.dynamicVersionRequirement;
    }

    @JsonProperty(value="dynamicVersionRequirement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDynamicVersionRequirement(OSVersionConstraintDynamicVersionRequirement dynamicVersionRequirement) {
        this.dynamicVersionRequirement = dynamicVersionRequirement;
    }

    public OSVersionConstraint majorVersionConstraint(MajorVersionConstraintEnum majorVersionConstraint) {
        this.majorVersionConstraint = majorVersionConstraint;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Indicates the Windows major version")
    @JsonProperty(value="majorVersionConstraint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MajorVersionConstraintEnum getMajorVersionConstraint() {
        return this.majorVersionConstraint;
    }

    @JsonProperty(value="majorVersionConstraint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMajorVersionConstraint(MajorVersionConstraintEnum majorVersionConstraint) {
        this.majorVersionConstraint = majorVersionConstraint;
    }

    public OSVersionConstraint minimum(String minimum) {
        this.minimum = minimum;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12.4.5.9", value="The Windows device version must be equal to or newer than the specified version")
    @JsonProperty(value="minimum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinimum() {
        return this.minimum;
    }

    @JsonProperty(value="minimum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSVersionConstraint osVersionConstraint = (OSVersionConstraint)o;
        return Objects.equals(this.dynamicVersionRequirement, osVersionConstraint.dynamicVersionRequirement) && Objects.equals((Object)this.majorVersionConstraint, (Object)osVersionConstraint.majorVersionConstraint) && Objects.equals(this.minimum, osVersionConstraint.minimum);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dynamicVersionRequirement, this.majorVersionConstraint, this.minimum});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OSVersionConstraint {\n");
        sb.append("    dynamicVersionRequirement: ").append(this.toIndentedString(this.dynamicVersionRequirement)).append("\n");
        sb.append("    majorVersionConstraint: ").append(this.toIndentedString((Object)this.majorVersionConstraint)).append("\n");
        sb.append("    minimum: ").append(this.toIndentedString(this.minimum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MajorVersionConstraintEnum {
        _11("WINDOWS_11"),
        _10("WINDOWS_10"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private MajorVersionConstraintEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MajorVersionConstraintEnum fromValue(String value) {
            for (MajorVersionConstraintEnum b : MajorVersionConstraintEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

