/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata about Okta as a transmitter and relevant information for configuration.")
@JsonPropertyOrder(value={"configuration_endpoint", "delivery_methods_supported", "issuer", "jwks_uri"})
public class WellKnownSSFMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CONFIGURATION_ENDPOINT = "configuration_endpoint";
    private URI configurationEndpoint;
    public static final String JSON_PROPERTY_DELIVERY_METHODS_SUPPORTED = "delivery_methods_supported";
    private List<URI> deliveryMethodsSupported = null;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private URI jwksUri;

    public WellKnownSSFMetadata configurationEndpoint(URI configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}/api/v1/ssf/stream", value="The URL of the SSF Stream configuration endpoint")
    @JsonProperty(value="configuration_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getConfigurationEndpoint() {
        return this.configurationEndpoint;
    }

    @JsonProperty(value="configuration_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfigurationEndpoint(URI configurationEndpoint) {
        this.configurationEndpoint = configurationEndpoint;
    }

    public WellKnownSSFMetadata deliveryMethodsSupported(List<URI> deliveryMethodsSupported) {
        this.deliveryMethodsSupported = deliveryMethodsSupported;
        return this;
    }

    public WellKnownSSFMetadata adddeliveryMethodsSupportedItem(URI deliveryMethodsSupportedItem) {
        if (this.deliveryMethodsSupported == null) {
            this.deliveryMethodsSupported = new ArrayList<URI>();
        }
        this.deliveryMethodsSupported.add(deliveryMethodsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"https://schemas.openid.net/secevent/risc/delivery-method/push\",\"urn:ietf:rfc:8935\"]", value="An array of supported SET delivery methods")
    @JsonProperty(value="delivery_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<URI> getDeliveryMethodsSupported() {
        return this.deliveryMethodsSupported;
    }

    @JsonProperty(value="delivery_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryMethodsSupported(List<URI> deliveryMethodsSupported) {
        this.deliveryMethodsSupported = deliveryMethodsSupported;
    }

    public WellKnownSSFMetadata issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}", value="The issuer used in Security Event Tokens. This value is set as `iss` in the claim.")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public WellKnownSSFMetadata jwksUri(URI jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://{yourOktaDomain}/oauth2/v1/keys", value="The URL of the JSON Web Key Set (JWKS) that contains the signing keys for validating the signatures of Security Event Tokens (SETs)")
    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public URI getJwksUri() {
        return this.jwksUri;
    }

    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUri(URI jwksUri) {
        this.jwksUri = jwksUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WellKnownSSFMetadata wellKnownSSFMetadata = (WellKnownSSFMetadata)o;
        return Objects.equals(this.configurationEndpoint, wellKnownSSFMetadata.configurationEndpoint) && Objects.equals(this.deliveryMethodsSupported, wellKnownSSFMetadata.deliveryMethodsSupported) && Objects.equals(this.issuer, wellKnownSSFMetadata.issuer) && Objects.equals(this.jwksUri, wellKnownSSFMetadata.jwksUri);
    }

    public int hashCode() {
        return Objects.hash(this.configurationEndpoint, this.deliveryMethodsSupported, this.issuer, this.jwksUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WellKnownSSFMetadata {\n");
        sb.append("    configurationEndpoint: ").append(this.toIndentedString(this.configurationEndpoint)).append("\n");
        sb.append("    deliveryMethodsSupported: ").append(this.toIndentedString(this.deliveryMethodsSupported)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

