/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.AuthorizationServerJsonWebKey;
import com.okta.sdk.resource.model.JwkUse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class AuthorizationServerKeysApi {
    private ApiClient apiClient;

    public AuthorizationServerKeysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerKeysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AuthorizationServerJsonWebKey getAuthorizationServerKey(String authServerId, String keyId) throws ApiException {
        return this.getAuthorizationServerKey(authServerId, keyId, Collections.emptyMap());
    }

    public AuthorizationServerJsonWebKey getAuthorizationServerKey(String authServerId, String keyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getAuthorizationServerKey");
        }
        if (keyId == null) {
            throw new ApiException(400, "Missing the required parameter 'keyId' when calling getAuthorizationServerKey");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/credentials/keys/{keyId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{keyId\\}", this.apiClient.escapeString(keyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<AuthorizationServerJsonWebKey> localVarReturnType = new TypeReference<AuthorizationServerJsonWebKey>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuthorizationServerJsonWebKey> listAuthorizationServerKeys(String authServerId) throws ApiException {
        return this.listAuthorizationServerKeys(authServerId, Collections.emptyMap());
    }

    public List<AuthorizationServerJsonWebKey> listAuthorizationServerKeys(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listAuthorizationServerKeys");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/credentials/keys".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServerJsonWebKey>> localVarReturnType = new TypeReference<List<AuthorizationServerJsonWebKey>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<AuthorizationServerJsonWebKey> rotateAuthorizationServerKeys(String authServerId, JwkUse use) throws ApiException {
        return this.rotateAuthorizationServerKeys(authServerId, use, Collections.emptyMap());
    }

    public List<AuthorizationServerJsonWebKey> rotateAuthorizationServerKeys(String authServerId, JwkUse use, Map<String, String> additionalHeaders) throws ApiException {
        JwkUse localVarPostBody = use;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling rotateAuthorizationServerKeys");
        }
        if (use == null) {
            throw new ApiException(400, "Missing the required parameter 'use' when calling rotateAuthorizationServerKeys");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/credentials/lifecycle/keyRotate".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<AuthorizationServerJsonWebKey>> localVarReturnType = new TypeReference<List<AuthorizationServerJsonWebKey>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

