/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.UserFactor;
import com.okta.sdk.resource.model.UserFactorPushProfile;
import com.okta.sdk.resource.model.UserFactorResultType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"expiresAt", "factorResult", "profile"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="factorType", visible=true, defaultImpl=UserFactorPush.class)
public class UserFactorPush
extends UserFactor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_FACTOR_RESULT = "factorResult";
    private UserFactorResultType factorResult;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private UserFactorPushProfile profile;

    @Nullable
    @ApiModelProperty(example="2022-08-25T00:31Z", value="Timestamp when the Factor verification attempt expires")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public UserFactorPush factorResult(UserFactorResultType factorResult) {
        this.factorResult = factorResult;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="factorResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorResultType getFactorResult() {
        return this.factorResult;
    }

    @JsonProperty(value="factorResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactorResult(UserFactorResultType factorResult) {
        this.factorResult = factorResult;
    }

    public UserFactorPush profile(UserFactorPushProfile profile) {
        this.profile = profile;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorPushProfile getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(UserFactorPushProfile profile) {
        this.profile = profile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFactorPush userFactorPush = (UserFactorPush)o;
        return Objects.equals(this.expiresAt, userFactorPush.expiresAt) && Objects.equals((Object)this.factorResult, (Object)userFactorPush.factorResult) && Objects.equals(this.profile, userFactorPush.profile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.expiresAt, this.factorResult, this.profile, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorPush {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    factorResult: ").append(this.toIndentedString((Object)this.factorResult)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

