/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.PrivilegedResource;
import com.okta.sdk.resource.model.PrivilegedResourceCredentials;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"resourceId", "credentials", "profile"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="resourceType", visible=true, defaultImpl=PrivilegedResourceAccountOkta.class)
public class PrivilegedResourceAccountOkta
extends PrivilegedResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_RESOURCE_ID = "resourceId";
    private String resourceId;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private PrivilegedResourceCredentials credentials;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    public PrivilegedResourceAccountOkta resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The user ID associated with the Okta privileged resource")
    @JsonProperty(value="resourceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getResourceId() {
        return this.resourceId;
    }

    @JsonProperty(value="resourceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public PrivilegedResourceAccountOkta credentials(PrivilegedResourceCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PrivilegedResourceCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(PrivilegedResourceCredentials credentials) {
        this.credentials = credentials;
    }

    @Nullable
    @ApiModelProperty(value="Specific profile properties for the privileged account")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedResourceAccountOkta privilegedResourceAccountOkta = (PrivilegedResourceAccountOkta)o;
        return Objects.equals(this.resourceId, privilegedResourceAccountOkta.resourceId) && Objects.equals(this.credentials, privilegedResourceAccountOkta.credentials) && Objects.equals(this.profile, privilegedResourceAccountOkta.profile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resourceId, this.credentials, this.profile, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedResourceAccountOkta {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

