/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonAdmin;
import com.okta.sdk.resource.model.CaepDeviceComplianceChangeEventReasonUser;
import com.okta.sdk.resource.model.SecurityEventSubject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="IP changed for the subject's session")
@JsonPropertyOrder(value={"current_ip_address", "event_timestamp", "initiating_entity", "previous_ip_address", "reason_admin", "reason_user", "subjects"})
public class OktaIpChangeEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CURRENT_IP_ADDRESS = "current_ip_address";
    private String currentIpAddress;
    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;
    public static final String JSON_PROPERTY_INITIATING_ENTITY = "initiating_entity";
    private InitiatingEntityEnum initiatingEntity;
    public static final String JSON_PROPERTY_PREVIOUS_IP_ADDRESS = "previous_ip_address";
    private String previousIpAddress;
    public static final String JSON_PROPERTY_REASON_ADMIN = "reason_admin";
    private CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin;
    public static final String JSON_PROPERTY_REASON_USER = "reason_user";
    private CaepDeviceComplianceChangeEventReasonUser reasonUser;
    public static final String JSON_PROPERTY_SUBJECTS = "subjects";
    private SecurityEventSubject subjects;

    public OktaIpChangeEvent currentIpAddress(String currentIpAddress) {
        this.currentIpAddress = currentIpAddress;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="123.4.5.6", required=true, value="Current IP address of the subject")
    @JsonProperty(value="current_ip_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCurrentIpAddress() {
        return this.currentIpAddress;
    }

    @JsonProperty(value="current_ip_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCurrentIpAddress(String currentIpAddress) {
        this.currentIpAddress = currentIpAddress;
    }

    public OktaIpChangeEvent eventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1702448550", required=true, value="The time of the event (UNIX timestamp)")
    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getEventTimestamp() {
        return this.eventTimestamp;
    }

    @JsonProperty(value="event_timestamp")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public OktaIpChangeEvent initiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The entity that initiated the event")
    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InitiatingEntityEnum getInitiatingEntity() {
        return this.initiatingEntity;
    }

    @JsonProperty(value="initiating_entity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitiatingEntity(InitiatingEntityEnum initiatingEntity) {
        this.initiatingEntity = initiatingEntity;
    }

    public OktaIpChangeEvent previousIpAddress(String previousIpAddress) {
        this.previousIpAddress = previousIpAddress;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="123.45.67.8", required=true, value="Previous IP address of the subject")
    @JsonProperty(value="previous_ip_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPreviousIpAddress() {
        return this.previousIpAddress;
    }

    @JsonProperty(value="previous_ip_address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPreviousIpAddress(String previousIpAddress) {
        this.previousIpAddress = previousIpAddress;
    }

    public OktaIpChangeEvent reasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepDeviceComplianceChangeEventReasonAdmin getReasonAdmin() {
        return this.reasonAdmin;
    }

    @JsonProperty(value="reason_admin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonAdmin(CaepDeviceComplianceChangeEventReasonAdmin reasonAdmin) {
        this.reasonAdmin = reasonAdmin;
    }

    public OktaIpChangeEvent reasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaepDeviceComplianceChangeEventReasonUser getReasonUser() {
        return this.reasonUser;
    }

    @JsonProperty(value="reason_user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReasonUser(CaepDeviceComplianceChangeEventReasonUser reasonUser) {
        this.reasonUser = reasonUser;
    }

    public OktaIpChangeEvent subjects(SecurityEventSubject subjects) {
        this.subjects = subjects;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="subjects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityEventSubject getSubjects() {
        return this.subjects;
    }

    @JsonProperty(value="subjects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubjects(SecurityEventSubject subjects) {
        this.subjects = subjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OktaIpChangeEvent oktaIpChangeEvent = (OktaIpChangeEvent)o;
        return Objects.equals(this.currentIpAddress, oktaIpChangeEvent.currentIpAddress) && Objects.equals(this.eventTimestamp, oktaIpChangeEvent.eventTimestamp) && Objects.equals((Object)this.initiatingEntity, (Object)oktaIpChangeEvent.initiatingEntity) && Objects.equals(this.previousIpAddress, oktaIpChangeEvent.previousIpAddress) && Objects.equals(this.reasonAdmin, oktaIpChangeEvent.reasonAdmin) && Objects.equals(this.reasonUser, oktaIpChangeEvent.reasonUser) && Objects.equals(this.subjects, oktaIpChangeEvent.subjects);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.currentIpAddress, this.eventTimestamp, this.initiatingEntity, this.previousIpAddress, this.reasonAdmin, this.reasonUser, this.subjects});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaIpChangeEvent {\n");
        sb.append("    currentIpAddress: ").append(this.toIndentedString(this.currentIpAddress)).append("\n");
        sb.append("    eventTimestamp: ").append(this.toIndentedString(this.eventTimestamp)).append("\n");
        sb.append("    initiatingEntity: ").append(this.toIndentedString((Object)this.initiatingEntity)).append("\n");
        sb.append("    previousIpAddress: ").append(this.toIndentedString(this.previousIpAddress)).append("\n");
        sb.append("    reasonAdmin: ").append(this.toIndentedString(this.reasonAdmin)).append("\n");
        sb.append("    reasonUser: ").append(this.toIndentedString(this.reasonUser)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InitiatingEntityEnum {
        ADMIN("admin"),
        USER("user"),
        POLICY("policy"),
        SYSTEM("system"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private InitiatingEntityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InitiatingEntityEnum fromValue(String value) {
            for (InitiatingEntityEnum b : InitiatingEntityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

