/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.GrantOrTokenStatus;
import com.okta.sdk.resource.model.OAuth2Actor;
import com.okta.sdk.resource.model.OAuth2ScopeConsentGrantEmbedded;
import com.okta.sdk.resource.model.OAuth2ScopeConsentGrantLinks;
import com.okta.sdk.resource.model.OAuth2ScopeConsentGrantSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Grant object that represents an app consent scope grant")
@JsonPropertyOrder(value={"clientId", "created", "createdBy", "id", "issuer", "lastUpdated", "scopeId", "source", "status", "userId", "_embedded", "_links"})
public class OAuth2ScopeConsentGrant
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_CREATED_BY = "createdBy";
    private OAuth2Actor createdBy;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_SCOPE_ID = "scopeId";
    private String scopeId;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private OAuth2ScopeConsentGrantSource source;
    public static final String JSON_PROPERTY_STATUS = "status";
    private GrantOrTokenStatus status;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;
    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private OAuth2ScopeConsentGrantEmbedded embedded;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuth2ScopeConsentGrantLinks links;

    @Nullable
    @ApiModelProperty(value="Client ID of the app integration")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the object was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public OAuth2ScopeConsentGrant createdBy(OAuth2Actor createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuth2Actor getCreatedBy() {
        return this.createdBy;
    }

    @JsonProperty(value="createdBy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedBy(OAuth2Actor createdBy) {
        this.createdBy = createdBy;
    }

    @Nullable
    @ApiModelProperty(value="ID of the Grant object")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public OAuth2ScopeConsentGrant issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://my_test_okta_org.oktapreview.com", required=true, value="The issuer of your org authorization server. This is typically your Okta domain.")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the object was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public OAuth2ScopeConsentGrant scopeId(String scopeId) {
        this.scopeId = scopeId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="okta.users.read", required=true, value="The name of the [Okta scope](https://developer.okta.com/docs/api/oauth2/#oauth-20-scopes) for which consent is granted")
    @JsonProperty(value="scopeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getScopeId() {
        return this.scopeId;
    }

    @JsonProperty(value="scopeId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public OAuth2ScopeConsentGrant source(OAuth2ScopeConsentGrantSource source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuth2ScopeConsentGrantSource getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(OAuth2ScopeConsentGrantSource source) {
        this.source = source;
    }

    public OAuth2ScopeConsentGrant status(GrantOrTokenStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public GrantOrTokenStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(GrantOrTokenStatus status) {
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(value="User ID that granted consent (if `source` is `END_USER`)")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserId() {
        return this.userId;
    }

    public OAuth2ScopeConsentGrant embedded(OAuth2ScopeConsentGrantEmbedded embedded) {
        this.embedded = embedded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuth2ScopeConsentGrantEmbedded getEmbedded() {
        return this.embedded;
    }

    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmbedded(OAuth2ScopeConsentGrantEmbedded embedded) {
        this.embedded = embedded;
    }

    public OAuth2ScopeConsentGrant links(OAuth2ScopeConsentGrantLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuth2ScopeConsentGrantLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuth2ScopeConsentGrantLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2ScopeConsentGrant oauth2ScopeConsentGrant = (OAuth2ScopeConsentGrant)o;
        return Objects.equals(this.clientId, oauth2ScopeConsentGrant.clientId) && Objects.equals(this.created, oauth2ScopeConsentGrant.created) && Objects.equals(this.createdBy, oauth2ScopeConsentGrant.createdBy) && Objects.equals(this.id, oauth2ScopeConsentGrant.id) && Objects.equals(this.issuer, oauth2ScopeConsentGrant.issuer) && Objects.equals(this.lastUpdated, oauth2ScopeConsentGrant.lastUpdated) && Objects.equals(this.scopeId, oauth2ScopeConsentGrant.scopeId) && Objects.equals((Object)this.source, (Object)oauth2ScopeConsentGrant.source) && Objects.equals((Object)this.status, (Object)oauth2ScopeConsentGrant.status) && Objects.equals(this.userId, oauth2ScopeConsentGrant.userId) && Objects.equals(this.embedded, oauth2ScopeConsentGrant.embedded) && Objects.equals(this.links, oauth2ScopeConsentGrant.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.created, this.createdBy, this.id, this.issuer, this.lastUpdated, this.scopeId, this.source, this.status, this.userId, this.embedded, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2ScopeConsentGrant {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    scopeId: ").append(this.toIndentedString(this.scopeId)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

