/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"created", "managementStatus", "screenLockType", "user"})
public class DeviceUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;
    public static final String JSON_PROPERTY_MANAGEMENT_STATUS = "managementStatus";
    private ManagementStatusEnum managementStatus;
    public static final String JSON_PROPERTY_SCREEN_LOCK_TYPE = "screenLockType";
    private ScreenLockTypeEnum screenLockType;
    public static final String JSON_PROPERTY_USER = "user";
    private User user;

    public DeviceUser created(String created) {
        this.created = created;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when device was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreated() {
        return this.created;
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreated(String created) {
        this.created = created;
    }

    public DeviceUser managementStatus(ManagementStatusEnum managementStatus) {
        this.managementStatus = managementStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The management status of the device")
    @JsonProperty(value="managementStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ManagementStatusEnum getManagementStatus() {
        return this.managementStatus;
    }

    @JsonProperty(value="managementStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManagementStatus(ManagementStatusEnum managementStatus) {
        this.managementStatus = managementStatus;
    }

    public DeviceUser screenLockType(ScreenLockTypeEnum screenLockType) {
        this.screenLockType = screenLockType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Screen lock type of the device")
    @JsonProperty(value="screenLockType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ScreenLockTypeEnum getScreenLockType() {
        return this.screenLockType;
    }

    @JsonProperty(value="screenLockType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScreenLockType(ScreenLockTypeEnum screenLockType) {
        this.screenLockType = screenLockType;
    }

    public DeviceUser user(User user) {
        this.user = user;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public User getUser() {
        return this.user;
    }

    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUser(User user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceUser deviceUser = (DeviceUser)o;
        return Objects.equals(this.created, deviceUser.created) && Objects.equals((Object)this.managementStatus, (Object)deviceUser.managementStatus) && Objects.equals((Object)this.screenLockType, (Object)deviceUser.screenLockType) && Objects.equals(this.user, deviceUser.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.managementStatus, this.screenLockType, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceUser {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    managementStatus: ").append(this.toIndentedString((Object)this.managementStatus)).append("\n");
        sb.append("    screenLockType: ").append(this.toIndentedString((Object)this.screenLockType)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ManagementStatusEnum {
        MANAGED("MANAGED"),
        NOT_MANAGED("NOT_MANAGED"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ManagementStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ManagementStatusEnum fromValue(String value) {
            for (ManagementStatusEnum b : ManagementStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum ScreenLockTypeEnum {
        NONE("NONE"),
        PASSCODE("PASSCODE"),
        BIOMETRIC("BIOMETRIC"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ScreenLockTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ScreenLockTypeEnum fromValue(String value) {
            for (ScreenLockTypeEnum b : ScreenLockTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

