/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.RolePermissionType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"description", "label", "permissions"})
public class CreateIamRoleRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private List<RolePermissionType> permissions = new ArrayList<RolePermissionType>();

    public CreateIamRoleRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Description of the role")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDescription(String description) {
        this.description = description;
    }

    public CreateIamRoleRequest label(String label) {
        this.label = label;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Unique label for the role")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    public CreateIamRoleRequest permissions(List<RolePermissionType> permissions) {
        this.permissions = permissions;
        return this;
    }

    public CreateIamRoleRequest addpermissionsItem(RolePermissionType permissionsItem) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<RolePermissionType>();
        }
        this.permissions.add(permissionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Array of permissions that the role will grant. See [Permissions](/openapi/okta-management/guides/roles/#permission).")
    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<RolePermissionType> getPermissions() {
        return this.permissions;
    }

    @JsonProperty(value="permissions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPermissions(List<RolePermissionType> permissions) {
        this.permissions = permissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateIamRoleRequest createIamRoleRequest = (CreateIamRoleRequest)o;
        return Objects.equals(this.description, createIamRoleRequest.description) && Objects.equals(this.label, createIamRoleRequest.label) && Objects.equals(this.permissions, createIamRoleRequest.permissions);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.label, this.permissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateIamRoleRequest {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    permissions: ").append(this.toIndentedString(this.permissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

