/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.AuthenticatorMethodWithVerifiableProperties;
import com.okta.sdk.resource.model.OtpProtocol;
import com.okta.sdk.resource.model.OtpTotpAlgorithm;
import com.okta.sdk.resource.model.OtpTotpEncoding;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"acceptableAdjacentIntervals", "algorithm", "encoding", "factorProfileId", "passCodeLength", "protocol", "timeIntervalInSeconds"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=AuthenticatorMethodOtp.class)
public class AuthenticatorMethodOtp
extends AuthenticatorMethodWithVerifiableProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCEPTABLE_ADJACENT_INTERVALS = "acceptableAdjacentIntervals";
    private Integer acceptableAdjacentIntervals;
    public static final String JSON_PROPERTY_ALGORITHM = "algorithm";
    private OtpTotpAlgorithm algorithm;
    public static final String JSON_PROPERTY_ENCODING = "encoding";
    private OtpTotpEncoding encoding;
    public static final String JSON_PROPERTY_FACTOR_PROFILE_ID = "factorProfileId";
    private String factorProfileId;
    public static final String JSON_PROPERTY_PASS_CODE_LENGTH = "passCodeLength";
    private Integer passCodeLength;
    public static final String JSON_PROPERTY_PROTOCOL = "protocol";
    private OtpProtocol protocol;
    public static final String JSON_PROPERTY_TIME_INTERVAL_IN_SECONDS = "timeIntervalInSeconds";
    private Integer timeIntervalInSeconds;

    public AuthenticatorMethodOtp acceptableAdjacentIntervals(Integer acceptableAdjacentIntervals) {
        this.acceptableAdjacentIntervals = acceptableAdjacentIntervals;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of acceptable adjacent intervals, also known as the clock drift interval. This setting allows you to build in tolerance for any time difference between the token and the server. For example, with a `timeIntervalInSeconds` of 60 seconds and an `acceptableAdjacentIntervals` value of 5, Okta accepts passcodes within 300 seconds (60 * 5) before or after the end user enters their code.")
    @JsonProperty(value="acceptableAdjacentIntervals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAcceptableAdjacentIntervals() {
        return this.acceptableAdjacentIntervals;
    }

    @JsonProperty(value="acceptableAdjacentIntervals")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptableAdjacentIntervals(Integer acceptableAdjacentIntervals) {
        this.acceptableAdjacentIntervals = acceptableAdjacentIntervals;
    }

    public AuthenticatorMethodOtp algorithm(OtpTotpAlgorithm algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OtpTotpAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithm(OtpTotpAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public AuthenticatorMethodOtp encoding(OtpTotpEncoding encoding) {
        this.encoding = encoding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="encoding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OtpTotpEncoding getEncoding() {
        return this.encoding;
    }

    @JsonProperty(value="encoding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncoding(OtpTotpEncoding encoding) {
        this.encoding = encoding;
    }

    public AuthenticatorMethodOtp factorProfileId(String factorProfileId) {
        this.factorProfileId = factorProfileId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="aut1nd8PQhGcQtSxB0g4", value="The `id` value of the factor profile")
    @JsonProperty(value="factorProfileId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFactorProfileId() {
        return this.factorProfileId;
    }

    @JsonProperty(value="factorProfileId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactorProfileId(String factorProfileId) {
        this.factorProfileId = factorProfileId;
    }

    public AuthenticatorMethodOtp passCodeLength(Integer passCodeLength) {
        this.passCodeLength = passCodeLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of digits in an OTP value")
    @JsonProperty(value="passCodeLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getPassCodeLength() {
        return this.passCodeLength;
    }

    @JsonProperty(value="passCodeLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassCodeLength(Integer passCodeLength) {
        this.passCodeLength = passCodeLength;
    }

    public AuthenticatorMethodOtp protocol(OtpProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OtpProtocol getProtocol() {
        return this.protocol;
    }

    @JsonProperty(value="protocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProtocol(OtpProtocol protocol) {
        this.protocol = protocol;
    }

    public AuthenticatorMethodOtp timeIntervalInSeconds(Integer timeIntervalInSeconds) {
        this.timeIntervalInSeconds = timeIntervalInSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time interval for TOTP in seconds")
    @JsonProperty(value="timeIntervalInSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTimeIntervalInSeconds() {
        return this.timeIntervalInSeconds;
    }

    @JsonProperty(value="timeIntervalInSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimeIntervalInSeconds(Integer timeIntervalInSeconds) {
        this.timeIntervalInSeconds = timeIntervalInSeconds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorMethodOtp authenticatorMethodOtp = (AuthenticatorMethodOtp)o;
        return Objects.equals(this.acceptableAdjacentIntervals, authenticatorMethodOtp.acceptableAdjacentIntervals) && Objects.equals((Object)this.algorithm, (Object)authenticatorMethodOtp.algorithm) && Objects.equals((Object)this.encoding, (Object)authenticatorMethodOtp.encoding) && Objects.equals(this.factorProfileId, authenticatorMethodOtp.factorProfileId) && Objects.equals(this.passCodeLength, authenticatorMethodOtp.passCodeLength) && Objects.equals((Object)this.protocol, (Object)authenticatorMethodOtp.protocol) && Objects.equals(this.timeIntervalInSeconds, authenticatorMethodOtp.timeIntervalInSeconds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptableAdjacentIntervals, this.algorithm, this.encoding, this.factorProfileId, this.passCodeLength, this.protocol, this.timeIntervalInSeconds, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorMethodOtp {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    acceptableAdjacentIntervals: ").append(this.toIndentedString(this.acceptableAdjacentIntervals)).append("\n");
        sb.append("    algorithm: ").append(this.toIndentedString((Object)this.algorithm)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString((Object)this.encoding)).append("\n");
        sb.append("    factorProfileId: ").append(this.toIndentedString(this.factorProfileId)).append("\n");
        sb.append("    passCodeLength: ").append(this.toIndentedString(this.passCodeLength)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString((Object)this.protocol)).append("\n");
        sb.append("    timeIntervalInSeconds: ").append(this.toIndentedString(this.timeIntervalInSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

