/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.ApplicationFeatureLinks;
import com.okta.sdk.resource.model.ApplicationFeatureType;
import com.okta.sdk.resource.model.EnabledStatus;
import com.okta.sdk.resource.model.InboundProvisioningApplicationFeature;
import com.okta.sdk.resource.model.UserProvisioningApplicationFeature;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The Feature object is used to configure application feature settings. ")
@JsonPropertyOrder(value={"description", "name", "status", "_links"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="name", visible=true, defaultImpl=ApplicationFeature.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=InboundProvisioningApplicationFeature.class, name="INBOUND_PROVISIONING"), @JsonSubTypes.Type(value=UserProvisioningApplicationFeature.class, name="USER_PROVISIONING")})
public class ApplicationFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    protected ApplicationFeatureType name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private EnabledStatus status;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private ApplicationFeatureLinks links;

    @Nullable
    @ApiModelProperty(example="Settings for provisioning users from Okta to a downstream application", value="Description of the feature")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public ApplicationFeature name(ApplicationFeatureType name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationFeatureType getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(ApplicationFeatureType name) {
        this.name = name;
    }

    public ApplicationFeature status(EnabledStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EnabledStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(EnabledStatus status) {
        this.status = status;
    }

    public ApplicationFeature links(ApplicationFeatureLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationFeatureLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ApplicationFeatureLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationFeature applicationFeature = (ApplicationFeature)o;
        return Objects.equals(this.description, applicationFeature.description) && Objects.equals((Object)this.name, (Object)applicationFeature.name) && Objects.equals((Object)this.status, (Object)applicationFeature.status) && Objects.equals(this.links, applicationFeature.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.description, this.name, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationFeature {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

