/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.Policy;
import com.okta.sdk.resource.model.PolicyMapping;
import com.okta.sdk.resource.model.PolicyMappingRequest;
import com.okta.sdk.resource.model.PolicyRule;
import com.okta.sdk.resource.model.SimulatePolicyBody;
import com.okta.sdk.resource.model.SimulatePolicyEvaluations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class PolicyApi {
    private ApiClient apiClient;

    public PolicyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PolicyApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void activatePolicy(String policyId) throws ApiException {
        this.activatePolicy(policyId, Collections.emptyMap());
    }

    public void activatePolicy(String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling activatePolicy");
        }
        String localVarPath = "/api/v1/policies/{policyId}/lifecycle/activate".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void activatePolicyRule(String policyId, String ruleId) throws ApiException {
        this.activatePolicyRule(policyId, ruleId, Collections.emptyMap());
    }

    public void activatePolicyRule(String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling activatePolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling activatePolicyRule");
        }
        String localVarPath = "/api/v1/policies/{policyId}/rules/{ruleId}/lifecycle/activate".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Policy clonePolicy(String policyId) throws ApiException {
        return this.clonePolicy(policyId, Collections.emptyMap());
    }

    public Policy clonePolicy(String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling clonePolicy");
        }
        String localVarPath = "/api/v1/policies/{policyId}/clone".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Policy> localVarReturnType = new TypeReference<Policy>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Policy createPolicy(Policy policy, Boolean activate) throws ApiException {
        return this.createPolicy(policy, activate, Collections.emptyMap());
    }

    public Policy createPolicy(Policy policy, Boolean activate, Map<String, String> additionalHeaders) throws ApiException {
        Policy localVarPostBody = policy;
        if (policy == null) {
            throw new ApiException(400, "Missing the required parameter 'policy' when calling createPolicy");
        }
        String localVarPath = "/api/v1/policies";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activate", activate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Policy> localVarReturnType = new TypeReference<Policy>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PolicyRule createPolicyRule(String policyId, PolicyRule policyRule, Boolean activate) throws ApiException {
        return this.createPolicyRule(policyId, policyRule, activate, Collections.emptyMap());
    }

    public PolicyRule createPolicyRule(String policyId, PolicyRule policyRule, Boolean activate, Map<String, String> additionalHeaders) throws ApiException {
        PolicyRule localVarPostBody = policyRule;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling createPolicyRule");
        }
        if (policyRule == null) {
            throw new ApiException(400, "Missing the required parameter 'policyRule' when calling createPolicyRule");
        }
        String localVarPath = "/api/v1/policies/{policyId}/rules".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activate", activate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PolicyRule> localVarReturnType = new TypeReference<PolicyRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<SimulatePolicyEvaluations> createPolicySimulation(List<SimulatePolicyBody> simulatePolicy, String expand) throws ApiException {
        return this.createPolicySimulation(simulatePolicy, expand, Collections.emptyMap());
    }

    public List<SimulatePolicyEvaluations> createPolicySimulation(List<SimulatePolicyBody> simulatePolicy, String expand, Map<String, String> additionalHeaders) throws ApiException {
        List<SimulatePolicyBody> localVarPostBody = simulatePolicy;
        if (simulatePolicy == null) {
            throw new ApiException(400, "Missing the required parameter 'simulatePolicy' when calling createPolicySimulation");
        }
        String localVarPath = "/api/v1/policies/simulate";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<SimulatePolicyEvaluations>> localVarReturnType = new TypeReference<List<SimulatePolicyEvaluations>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deactivatePolicy(String policyId) throws ApiException {
        this.deactivatePolicy(policyId, Collections.emptyMap());
    }

    public void deactivatePolicy(String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deactivatePolicy");
        }
        String localVarPath = "/api/v1/policies/{policyId}/lifecycle/deactivate".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deactivatePolicyRule(String policyId, String ruleId) throws ApiException {
        this.deactivatePolicyRule(policyId, ruleId, Collections.emptyMap());
    }

    public void deactivatePolicyRule(String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deactivatePolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deactivatePolicyRule");
        }
        String localVarPath = "/api/v1/policies/{policyId}/rules/{ruleId}/lifecycle/deactivate".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deletePolicy(String policyId) throws ApiException {
        this.deletePolicy(policyId, Collections.emptyMap());
    }

    public void deletePolicy(String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deletePolicy");
        }
        String localVarPath = "/api/v1/policies/{policyId}".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deletePolicyResourceMapping(String policyId, String mappingId) throws ApiException {
        this.deletePolicyResourceMapping(policyId, mappingId, Collections.emptyMap());
    }

    public void deletePolicyResourceMapping(String policyId, String mappingId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deletePolicyResourceMapping");
        }
        if (mappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'mappingId' when calling deletePolicyResourceMapping");
        }
        String localVarPath = "/api/v1/policies/{policyId}/mappings/{mappingId}".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{mappingId\\}", this.apiClient.escapeString(mappingId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deletePolicyRule(String policyId, String ruleId) throws ApiException {
        this.deletePolicyRule(policyId, ruleId, Collections.emptyMap());
    }

    public void deletePolicyRule(String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deletePolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deletePolicyRule");
        }
        String localVarPath = "/api/v1/policies/{policyId}/rules/{ruleId}".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public Policy getPolicy(String policyId, String expand) throws ApiException {
        return this.getPolicy(policyId, expand, Collections.emptyMap());
    }

    public Policy getPolicy(String policyId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getPolicy");
        }
        String localVarPath = "/api/v1/policies/{policyId}".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Policy> localVarReturnType = new TypeReference<Policy>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PolicyMapping getPolicyMapping(String policyId, String mappingId) throws ApiException {
        return this.getPolicyMapping(policyId, mappingId, Collections.emptyMap());
    }

    public PolicyMapping getPolicyMapping(String policyId, String mappingId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getPolicyMapping");
        }
        if (mappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'mappingId' when calling getPolicyMapping");
        }
        String localVarPath = "/api/v1/policies/{policyId}/mappings/{mappingId}".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{mappingId\\}", this.apiClient.escapeString(mappingId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PolicyMapping> localVarReturnType = new TypeReference<PolicyMapping>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PolicyRule getPolicyRule(String policyId, String ruleId) throws ApiException {
        return this.getPolicyRule(policyId, ruleId, Collections.emptyMap());
    }

    public PolicyRule getPolicyRule(String policyId, String ruleId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getPolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getPolicyRule");
        }
        String localVarPath = "/api/v1/policies/{policyId}/rules/{ruleId}".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PolicyRule> localVarReturnType = new TypeReference<PolicyRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Policy> listPolicies(String type, String status, String expand, String sortBy, String limit, String after) throws ApiException {
        return this.listPolicies(type, status, expand, sortBy, limit, after, Collections.emptyMap());
    }

    public List<Policy> listPolicies(String type, String status, String expand, String sortBy, String limit, String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (type == null) {
            throw new ApiException(400, "Missing the required parameter 'type' when calling listPolicies");
        }
        String localVarPath = "/api/v1/policies";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Policy>> localVarReturnType = new TypeReference<List<Policy>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Deprecated
    public List<Application> listPolicyApps(String policyId) throws ApiException {
        return this.listPolicyApps(policyId, Collections.emptyMap());
    }

    @Deprecated
    public List<Application> listPolicyApps(String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling listPolicyApps");
        }
        String localVarPath = "/api/v1/policies/{policyId}/app".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Application>> localVarReturnType = new TypeReference<List<Application>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<PolicyMapping> listPolicyMappings(String policyId) throws ApiException {
        return this.listPolicyMappings(policyId, Collections.emptyMap());
    }

    public List<PolicyMapping> listPolicyMappings(String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling listPolicyMappings");
        }
        String localVarPath = "/api/v1/policies/{policyId}/mappings".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<PolicyMapping>> localVarReturnType = new TypeReference<List<PolicyMapping>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<PolicyRule> listPolicyRules(String policyId) throws ApiException {
        return this.listPolicyRules(policyId, Collections.emptyMap());
    }

    public List<PolicyRule> listPolicyRules(String policyId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling listPolicyRules");
        }
        String localVarPath = "/api/v1/policies/{policyId}/rules".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<PolicyRule>> localVarReturnType = new TypeReference<List<PolicyRule>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PolicyMapping mapResourceToPolicy(String policyId, PolicyMappingRequest policyMappingRequest) throws ApiException {
        return this.mapResourceToPolicy(policyId, policyMappingRequest, Collections.emptyMap());
    }

    public PolicyMapping mapResourceToPolicy(String policyId, PolicyMappingRequest policyMappingRequest, Map<String, String> additionalHeaders) throws ApiException {
        PolicyMappingRequest localVarPostBody = policyMappingRequest;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling mapResourceToPolicy");
        }
        if (policyMappingRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'policyMappingRequest' when calling mapResourceToPolicy");
        }
        String localVarPath = "/api/v1/policies/{policyId}/mappings".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PolicyMapping> localVarReturnType = new TypeReference<PolicyMapping>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Policy replacePolicy(String policyId, Policy policy) throws ApiException {
        return this.replacePolicy(policyId, policy, Collections.emptyMap());
    }

    public Policy replacePolicy(String policyId, Policy policy, Map<String, String> additionalHeaders) throws ApiException {
        Policy localVarPostBody = policy;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling replacePolicy");
        }
        if (policy == null) {
            throw new ApiException(400, "Missing the required parameter 'policy' when calling replacePolicy");
        }
        String localVarPath = "/api/v1/policies/{policyId}".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<Policy> localVarReturnType = new TypeReference<Policy>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public PolicyRule replacePolicyRule(String policyId, String ruleId, PolicyRule policyRule) throws ApiException {
        return this.replacePolicyRule(policyId, ruleId, policyRule, Collections.emptyMap());
    }

    public PolicyRule replacePolicyRule(String policyId, String ruleId, PolicyRule policyRule, Map<String, String> additionalHeaders) throws ApiException {
        PolicyRule localVarPostBody = policyRule;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling replacePolicyRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling replacePolicyRule");
        }
        if (policyRule == null) {
            throw new ApiException(400, "Missing the required parameter 'policyRule' when calling replacePolicyRule");
        }
        String localVarPath = "/api/v1/policies/{policyId}/rules/{ruleId}".replaceAll("\\{policyId\\}", this.apiClient.escapeString(policyId.toString())).replaceAll("\\{ruleId\\}", this.apiClient.escapeString(ruleId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PolicyRule> localVarReturnType = new TypeReference<PolicyRule>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

