/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PolicyContext;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The request body required for a simulate policy operation.")
@JsonPropertyOrder(value={"appInstance", "policyContext", "policyTypes"})
public class SimulatePolicyBody
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP_INSTANCE = "appInstance";
    private String appInstance;
    public static final String JSON_PROPERTY_POLICY_CONTEXT = "policyContext";
    private PolicyContext policyContext;
    public static final String JSON_PROPERTY_POLICY_TYPES = "policyTypes";
    private PolicyTypesEnum policyTypes;

    public SimulatePolicyBody appInstance(String appInstance) {
        this.appInstance = appInstance;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The application instance ID for a simulate operation")
    @JsonProperty(value="appInstance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAppInstance() {
        return this.appInstance;
    }

    @JsonProperty(value="appInstance")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAppInstance(String appInstance) {
        this.appInstance = appInstance;
    }

    public SimulatePolicyBody policyContext(PolicyContext policyContext) {
        this.policyContext = policyContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="policyContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PolicyContext getPolicyContext() {
        return this.policyContext;
    }

    @JsonProperty(value="policyContext")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicyContext(PolicyContext policyContext) {
        this.policyContext = policyContext;
    }

    public SimulatePolicyBody policyTypes(PolicyTypesEnum policyTypes) {
        this.policyTypes = policyTypes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Supported policy types for a simulate operation. The default value, `null`, returns all types.")
    @JsonProperty(value="policyTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PolicyTypesEnum getPolicyTypes() {
        return this.policyTypes;
    }

    @JsonProperty(value="policyTypes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPolicyTypes(PolicyTypesEnum policyTypes) {
        this.policyTypes = policyTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimulatePolicyBody simulatePolicyBody = (SimulatePolicyBody)o;
        return Objects.equals(this.appInstance, simulatePolicyBody.appInstance) && Objects.equals(this.policyContext, simulatePolicyBody.policyContext) && Objects.equals((Object)this.policyTypes, (Object)simulatePolicyBody.policyTypes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appInstance, this.policyContext, this.policyTypes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimulatePolicyBody {\n");
        sb.append("    appInstance: ").append(this.toIndentedString(this.appInstance)).append("\n");
        sb.append("    policyContext: ").append(this.toIndentedString(this.policyContext)).append("\n");
        sb.append("    policyTypes: ").append(this.toIndentedString((Object)this.policyTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PolicyTypesEnum {
        OKTA_SIGN_ON("OKTA_SIGN_ON"),
        MFA_ENROLL("MFA_ENROLL"),
        PROFILE_ENROLLMENT("PROFILE_ENROLLMENT"),
        ACCESS_POLICY("ACCESS_POLICY"),
        NULL("null"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PolicyTypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PolicyTypesEnum fromValue(String value) {
            for (PolicyTypesEnum b : PolicyTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

