/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationFeatureLinks;
import com.okta.sdk.resource.model.CapabilitiesObject;
import com.okta.sdk.resource.model.EnabledStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The Feature object is used to configure application feature settings.  The only feature currently supported is `USER_PROVISIONING` for the Org2Org application type. ")
@JsonPropertyOrder(value={"capabilities", "description", "name", "status", "_links"})
public class ApplicationFeature
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private CapabilitiesObject capabilities;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private NameEnum name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private EnabledStatus status;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private ApplicationFeatureLinks links;

    public ApplicationFeature capabilities(CapabilitiesObject capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CapabilitiesObject getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(CapabilitiesObject capabilities) {
        this.capabilities = capabilities;
    }

    @Nullable
    @ApiModelProperty(example="Settings for provisioning users from Okta to a downstream application", value="Description of the feature")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @Nullable
    @ApiModelProperty(example="USER_PROVISIONING", value="Identifying name of the feature")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NameEnum getName() {
        return this.name;
    }

    public ApplicationFeature status(EnabledStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EnabledStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(EnabledStatus status) {
        this.status = status;
    }

    public ApplicationFeature links(ApplicationFeatureLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationFeatureLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ApplicationFeatureLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationFeature applicationFeature = (ApplicationFeature)o;
        return Objects.equals(this.capabilities, applicationFeature.capabilities) && Objects.equals(this.description, applicationFeature.description) && Objects.equals((Object)this.name, (Object)applicationFeature.name) && Objects.equals((Object)this.status, (Object)applicationFeature.status) && Objects.equals(this.links, applicationFeature.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.description, this.name, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationFeature {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NameEnum {
        USER_PROVISIONING("USER_PROVISIONING"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private NameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NameEnum fromValue(String value) {
            for (NameEnum b : NameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

