/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PolicyType {
    ACCESS_POLICY("ACCESS_POLICY"),
    IDP_DISCOVERY("IDP_DISCOVERY"),
    MFA_ENROLL("MFA_ENROLL"),
    OKTA_SIGN_ON("OKTA_SIGN_ON"),
    OAUTH_AUTHORIZATION_POLICY("OAUTH_AUTHORIZATION_POLICY"),
    PASSWORD("PASSWORD"),
    PROFILE_ENROLLMENT("PROFILE_ENROLLMENT");

    private String value;

    private PolicyType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static PolicyType fromValue(String value) {
        for (PolicyType b : PolicyType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString().toString());
    }
}

