/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.helper;

import com.okta.commons.lang.Assert;
import com.okta.sdk.resource.model.AccessPolicy;
import com.okta.sdk.resource.model.AccessPolicyRule;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.AuthorizationServerPolicyRule;
import com.okta.sdk.resource.model.AutoLoginApplication;
import com.okta.sdk.resource.model.BasicAuthApplication;
import com.okta.sdk.resource.model.BookmarkApplication;
import com.okta.sdk.resource.model.BrowserPluginApplication;
import com.okta.sdk.resource.model.CallUserFactor;
import com.okta.sdk.resource.model.CustomHotpUserFactor;
import com.okta.sdk.resource.model.EmailUserFactor;
import com.okta.sdk.resource.model.HardwareUserFactor;
import com.okta.sdk.resource.model.IdentityProviderPolicy;
import com.okta.sdk.resource.model.MultifactorEnrollmentPolicy;
import com.okta.sdk.resource.model.OktaSignOnPolicy;
import com.okta.sdk.resource.model.OktaSignOnPolicyRule;
import com.okta.sdk.resource.model.OpenIdConnectApplication;
import com.okta.sdk.resource.model.PasswordPolicy;
import com.okta.sdk.resource.model.PasswordPolicyRule;
import com.okta.sdk.resource.model.Policy;
import com.okta.sdk.resource.model.PolicyRule;
import com.okta.sdk.resource.model.ProfileEnrollmentPolicy;
import com.okta.sdk.resource.model.ProfileEnrollmentPolicyRule;
import com.okta.sdk.resource.model.PushUserFactor;
import com.okta.sdk.resource.model.SamlApplication;
import com.okta.sdk.resource.model.SecurePasswordStoreApplication;
import com.okta.sdk.resource.model.SecurityQuestionUserFactor;
import com.okta.sdk.resource.model.SmsUserFactor;
import com.okta.sdk.resource.model.TokenUserFactor;
import com.okta.sdk.resource.model.TotpUserFactor;
import com.okta.sdk.resource.model.U2fUserFactor;
import com.okta.sdk.resource.model.UserFactor;
import com.okta.sdk.resource.model.WebAuthnUserFactor;
import com.okta.sdk.resource.model.WebUserFactor;
import com.okta.sdk.resource.model.WsFederationApplication;
import java.util.Objects;

public class HelperUtil {
    public static Class<? extends Application> getApplicationType(Application application) {
        Assert.notNull((Object)application);
        if (Objects.isNull((Object)application.getSignOnMode())) {
            return Application.class;
        }
        switch (application.getSignOnMode()) {
            case AUTO_LOGIN: {
                return AutoLoginApplication.class;
            }
            case BASIC_AUTH: {
                return BasicAuthApplication.class;
            }
            case BOOKMARK: {
                return BookmarkApplication.class;
            }
            case BROWSER_PLUGIN: {
                return BrowserPluginApplication.class;
            }
            case OPENID_CONNECT: {
                return OpenIdConnectApplication.class;
            }
            case SAML_1_1: 
            case SAML_2_0: {
                return SamlApplication.class;
            }
            case SECURE_PASSWORD_STORE: {
                return SecurePasswordStoreApplication.class;
            }
            case WS_FEDERATION: {
                return WsFederationApplication.class;
            }
        }
        return Application.class;
    }

    public static Class<? extends Policy> getPolicyType(Policy policy) {
        Assert.notNull((Object)policy);
        if (Objects.isNull((Object)policy.getType())) {
            return Policy.class;
        }
        switch (policy.getType()) {
            case ACCESS_POLICY: {
                return AccessPolicy.class;
            }
            case IDP_DISCOVERY: {
                return IdentityProviderPolicy.class;
            }
            case MFA_ENROLL: {
                return MultifactorEnrollmentPolicy.class;
            }
            case OKTA_SIGN_ON: {
                return OktaSignOnPolicy.class;
            }
            case PASSWORD: {
                return PasswordPolicy.class;
            }
            case PROFILE_ENROLLMENT: {
                return ProfileEnrollmentPolicy.class;
            }
        }
        return Policy.class;
    }

    public static Class<? extends UserFactor> getUserFactorType(UserFactor userFactor) {
        Assert.notNull((Object)userFactor);
        if (Objects.isNull((Object)userFactor.getFactorType())) {
            return UserFactor.class;
        }
        switch (userFactor.getFactorType()) {
            case CALL: {
                return CallUserFactor.class;
            }
            case EMAIL: {
                return EmailUserFactor.class;
            }
            case PUSH: {
                return PushUserFactor.class;
            }
            case SMS: {
                return SmsUserFactor.class;
            }
            case QUESTION: {
                return SecurityQuestionUserFactor.class;
            }
            case TOKEN: {
                return TokenUserFactor.class;
            }
            case TOKEN_HARDWARE: {
                return HardwareUserFactor.class;
            }
            case TOKEN_HOTP: {
                return CustomHotpUserFactor.class;
            }
            case TOKEN_SOFTWARE_TOTP: {
                return TotpUserFactor.class;
            }
            case U2F: {
                return U2fUserFactor.class;
            }
            case WEB: {
                return WebUserFactor.class;
            }
            case WEBAUTHN: {
                return WebAuthnUserFactor.class;
            }
        }
        return UserFactor.class;
    }

    public static Class<? extends PolicyRule> getPolicyRuleType(PolicyRule policyRule) {
        Assert.notNull((Object)policyRule);
        if (Objects.isNull((Object)policyRule.getType())) {
            return PolicyRule.class;
        }
        switch (policyRule.getType()) {
            case ACCESS_POLICY: {
                return AccessPolicyRule.class;
            }
            case IDP_DISCOVERY: {
                return AuthorizationServerPolicyRule.class;
            }
            case PASSWORD: {
                return PasswordPolicyRule.class;
            }
            case PROFILE_ENROLLMENT: {
                return ProfileEnrollmentPolicyRule.class;
            }
            case SIGN_ON: {
                return OktaSignOnPolicyRule.class;
            }
        }
        return PolicyRule.class;
    }
}

