/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.AuthenticatorIdentity;

@ApiModel(description="Limits the authenticators that can be used for a given method. Currently, only the `otp` method supports constraints, and Google authenticator (key : 'google_otp') is the only allowed authenticator.")
@JsonPropertyOrder(value={"allowedAuthenticators", "method"})
public class AuthenticatorMethodConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALLOWED_AUTHENTICATORS = "allowedAuthenticators";
    private List<AuthenticatorIdentity> allowedAuthenticators = null;
    public static final String JSON_PROPERTY_METHOD = "method";
    private MethodEnum method;

    public AuthenticatorMethodConstraint allowedAuthenticators(List<AuthenticatorIdentity> allowedAuthenticators) {
        this.allowedAuthenticators = allowedAuthenticators;
        return this;
    }

    public AuthenticatorMethodConstraint addAllowedAuthenticatorsItem(AuthenticatorIdentity allowedAuthenticatorsItem) {
        if (this.allowedAuthenticators == null) {
            this.allowedAuthenticators = new ArrayList<AuthenticatorIdentity>();
        }
        this.allowedAuthenticators.add(allowedAuthenticatorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="allowedAuthenticators")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthenticatorIdentity> getAllowedAuthenticators() {
        return this.allowedAuthenticators;
    }

    @JsonProperty(value="allowedAuthenticators")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedAuthenticators(List<AuthenticatorIdentity> allowedAuthenticators) {
        this.allowedAuthenticators = allowedAuthenticators;
    }

    public AuthenticatorMethodConstraint method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MethodEnum getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorMethodConstraint authenticatorMethodConstraint = (AuthenticatorMethodConstraint)o;
        return Objects.equals(this.allowedAuthenticators, authenticatorMethodConstraint.allowedAuthenticators) && Objects.equals((Object)this.method, (Object)authenticatorMethodConstraint.method);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowedAuthenticators, this.method});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorMethodConstraint {\n");
        sb.append("    allowedAuthenticators: ").append(this.toIndentedString(this.allowedAuthenticators)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MethodEnum {
        OTP("otp");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

