/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.ActivateFactorRequest;
import org.openapitools.client.model.SecurityQuestion;
import org.openapitools.client.model.UserFactor;
import org.openapitools.client.model.VerifyFactorRequest;
import org.openapitools.client.model.VerifyUserFactorResponse;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class UserFactorApi {
    private ApiClient apiClient;

    public UserFactorApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserFactorApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public UserFactor activateFactor(String userId, String factorId, ActivateFactorRequest body) throws ApiException {
        return this.activateFactor(userId, factorId, body, Collections.emptyMap());
    }

    public UserFactor activateFactor(String userId, String factorId, ActivateFactorRequest body, Map<String, String> additionalHeaders) throws ApiException {
        ActivateFactorRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling activateFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling activateFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactor> localVarReturnType = new TypeReference<UserFactor>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserFactor enrollFactor(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws ApiException {
        return this.enrollFactor(userId, body, updatePhone, templateId, tokenLifetimeSeconds, activate, Collections.emptyMap());
    }

    public UserFactor enrollFactor(String userId, UserFactor body, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate, Map<String, String> additionalHeaders) throws ApiException {
        UserFactor localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling enrollFactor");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling enrollFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("updatePhone", updatePhone));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tokenLifetimeSeconds", tokenLifetimeSeconds));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activate", activate));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactor> localVarReturnType = new TypeReference<UserFactor>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserFactor getFactor(String userId, String factorId) throws ApiException {
        return this.getFactor(userId, factorId, Collections.emptyMap());
    }

    public UserFactor getFactor(String userId, String factorId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling getFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactor> localVarReturnType = new TypeReference<UserFactor>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public VerifyUserFactorResponse getFactorTransactionStatus(String userId, String factorId, String transactionId) throws ApiException {
        return this.getFactorTransactionStatus(userId, factorId, transactionId, Collections.emptyMap());
    }

    public VerifyUserFactorResponse getFactorTransactionStatus(String userId, String factorId, String transactionId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getFactorTransactionStatus");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling getFactorTransactionStatus");
        }
        if (transactionId == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionId' when calling getFactorTransactionStatus");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/transactions/{transactionId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString())).replaceAll("\\{transactionId\\}", this.apiClient.escapeString(transactionId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<VerifyUserFactorResponse> localVarReturnType = new TypeReference<VerifyUserFactorResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<UserFactor> listFactors(String userId) throws ApiException {
        return this.listFactors(userId, Collections.emptyMap());
    }

    public List<UserFactor> listFactors(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listFactors");
        }
        String localVarPath = "/api/v1/users/{userId}/factors".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<UserFactor>> localVarReturnType = new TypeReference<List<UserFactor>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<UserFactor> listSupportedFactors(String userId) throws ApiException {
        return this.listSupportedFactors(userId, Collections.emptyMap());
    }

    public List<UserFactor> listSupportedFactors(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSupportedFactors");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/catalog".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<UserFactor>> localVarReturnType = new TypeReference<List<UserFactor>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<SecurityQuestion> listSupportedSecurityQuestions(String userId) throws ApiException {
        return this.listSupportedSecurityQuestions(userId, Collections.emptyMap());
    }

    public List<SecurityQuestion> listSupportedSecurityQuestions(String userId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSupportedSecurityQuestions");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/questions".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken"};
        TypeReference<List<SecurityQuestion>> localVarReturnType = new TypeReference<List<SecurityQuestion>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public UserFactor resendEnrollFactor(String userId, String factorId, UserFactor userFactor, String templateId) throws ApiException {
        return this.resendEnrollFactor(userId, factorId, userFactor, templateId, Collections.emptyMap());
    }

    public UserFactor resendEnrollFactor(String userId, String factorId, UserFactor userFactor, String templateId, Map<String, String> additionalHeaders) throws ApiException {
        UserFactor localVarPostBody = userFactor;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling resendEnrollFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling resendEnrollFactor");
        }
        if (userFactor == null) {
            throw new ApiException(400, "Missing the required parameter 'userFactor' when calling resendEnrollFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/resend".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<UserFactor> localVarReturnType = new TypeReference<UserFactor>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unenrollFactor(String userId, String factorId, Boolean removeRecoveryEnrollment) throws ApiException {
        this.unenrollFactor(userId, factorId, removeRecoveryEnrollment, Collections.emptyMap());
    }

    public void unenrollFactor(String userId, String factorId, Boolean removeRecoveryEnrollment, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unenrollFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling unenrollFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("removeRecoveryEnrollment", removeRecoveryEnrollment));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public VerifyUserFactorResponse verifyFactor(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body) throws ApiException {
        return this.verifyFactor(userId, factorId, templateId, tokenLifetimeSeconds, xForwardedFor, userAgent, acceptLanguage, body, Collections.emptyMap());
    }

    public VerifyUserFactorResponse verifyFactor(String userId, String factorId, String templateId, Integer tokenLifetimeSeconds, String xForwardedFor, String userAgent, String acceptLanguage, VerifyFactorRequest body, Map<String, String> additionalHeaders) throws ApiException {
        VerifyFactorRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling verifyFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling verifyFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/verify".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{factorId\\}", this.apiClient.escapeString(factorId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("templateId", templateId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tokenLifetimeSeconds", tokenLifetimeSeconds));
        if (xForwardedFor != null) {
            localVarHeaderParams.put("X-Forwarded-For", this.apiClient.parameterToString(xForwardedFor));
        }
        if (userAgent != null) {
            localVarHeaderParams.put("User-Agent", this.apiClient.parameterToString(userAgent));
        }
        if (acceptLanguage != null) {
            localVarHeaderParams.put("Accept-Language", this.apiClient.parameterToString(acceptLanguage));
        }
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<VerifyUserFactorResponse> localVarReturnType = new TypeReference<VerifyUserFactorResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

