/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Defines the secondary authenticators needed for password reset if `required` is true. The following are three valid configurations: * `required`=false * `required`=true with no methods to use any SSO authenticator * `required`=true with `security_question` as the method")
@JsonPropertyOrder(value={"methods", "required"})
public class SsprStepUpRequirement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_METHODS = "methods";
    private List<MethodsEnum> methods = null;
    public static final String JSON_PROPERTY_REQUIRED = "required";
    private Boolean required;

    public SsprStepUpRequirement methods(List<MethodsEnum> methods) {
        this.methods = methods;
        return this;
    }

    public SsprStepUpRequirement addMethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Authenticator methods required for secondary authentication step of password recovery. Specify this value only when `required` is true and `security_question` is permitted for the secondary authentication.")
    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MethodsEnum> getMethods() {
        return this.methods;
    }

    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public SsprStepUpRequirement required(Boolean required) {
        this.required = required;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsprStepUpRequirement ssprStepUpRequirement = (SsprStepUpRequirement)o;
        return Objects.equals(this.methods, ssprStepUpRequirement.methods) && Objects.equals(this.required, ssprStepUpRequirement.required);
    }

    public int hashCode() {
        return Objects.hash(this.methods, this.required);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SsprStepUpRequirement {\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MethodsEnum {
        SECURITY_QUESTION("security_question");

        private String value;

        private MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            for (MethodsEnum b : MethodsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

