/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SessionAuthenticationMethod {
    FPT("fpt"),
    GEO("geo"),
    HWK("hwk"),
    KBA("kba"),
    MCA("mca"),
    MFA("mfa"),
    OTP("otp"),
    PWD("pwd"),
    SC("sc"),
    SMS("sms"),
    SWK("swk"),
    TEL("tel");

    private String value;

    private SessionAuthenticationMethod(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SessionAuthenticationMethod fromValue(String value) {
        for (SessionAuthenticationMethod b : SessionAuthenticationMethod.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

