/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.RiskEventSubject;

@JsonPropertyOrder(value={"expiresAt", "subjects", "timestamp"})
public class RiskEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_SUBJECTS = "subjects";
    private List<RiskEventSubject> subjects = new ArrayList<RiskEventSubject>();
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private OffsetDateTime timestamp;

    public RiskEvent expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp at which the event expires (expressed as a UTC time zone using ISO 8601 format: yyyy-MM-dd`T`HH:mm:ss.SSS`Z`). If this optional field is not included, Okta automatically expires the event 24 hours after the event is consumed.")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public RiskEvent subjects(List<RiskEventSubject> subjects) {
        this.subjects = subjects;
        return this;
    }

    public RiskEvent addSubjectsItem(RiskEventSubject subjectsItem) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<RiskEventSubject>();
        }
        this.subjects.add(subjectsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="List of Risk Event Subjects")
    @JsonProperty(value="subjects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<RiskEventSubject> getSubjects() {
        return this.subjects;
    }

    @JsonProperty(value="subjects")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubjects(List<RiskEventSubject> subjects) {
        this.subjects = subjects;
    }

    public RiskEvent timestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp of when the event is produced (expressed as a UTC time zone using ISO 8601 format: yyyy-MM-dd`T`HH:mm:ss.SSS`Z`)")
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiskEvent riskEvent = (RiskEvent)o;
        return Objects.equals(this.expiresAt, riskEvent.expiresAt) && Objects.equals(this.subjects, riskEvent.subjects) && Objects.equals(this.timestamp, riskEvent.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.expiresAt, this.subjects, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiskEvent {\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    subjects: ").append(this.toIndentedString(this.subjects)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

