/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum FactorType {
    CALL("call"),
    EMAIL("email"),
    PUSH("push"),
    QUESTION("question"),
    SIGNED_NONCE("signed_nonce"),
    SMS("sms"),
    TOKEN("token"),
    TOKEN_HARDWARE("token:hardware"),
    TOKEN_HOTP("token:hotp"),
    TOKEN_SOFTWARE_TOTP("token:software:totp"),
    U2F("u2f"),
    WEB("web"),
    WEBAUTHN("webauthn");

    private String value;

    private FactorType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static FactorType fromValue(String value) {
        for (FactorType b : FactorType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

