/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.DevicePlatform;
import org.openapitools.client.model.DiskEncryptionTypeDef;

@JsonPropertyOrder(value={"diskEncryptionType", "displayName", "imei", "integrityJailbreak", "manufacturer", "meid", "model", "osVersion", "platform", "registered", "secureHardwarePresent", "serialNumber", "sid", "tpmPublicKeyHash", "udid"})
public class DeviceProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DISK_ENCRYPTION_TYPE = "diskEncryptionType";
    private DiskEncryptionTypeDef diskEncryptionType;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_IMEI = "imei";
    private String imei;
    public static final String JSON_PROPERTY_INTEGRITY_JAILBREAK = "integrityJailbreak";
    private Boolean integrityJailbreak;
    public static final String JSON_PROPERTY_MANUFACTURER = "manufacturer";
    private String manufacturer;
    public static final String JSON_PROPERTY_MEID = "meid";
    private String meid;
    public static final String JSON_PROPERTY_MODEL = "model";
    private String model;
    public static final String JSON_PROPERTY_OS_VERSION = "osVersion";
    private String osVersion;
    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private DevicePlatform platform;
    public static final String JSON_PROPERTY_REGISTERED = "registered";
    private Boolean registered;
    public static final String JSON_PROPERTY_SECURE_HARDWARE_PRESENT = "secureHardwarePresent";
    private Boolean secureHardwarePresent;
    public static final String JSON_PROPERTY_SERIAL_NUMBER = "serialNumber";
    private String serialNumber;
    public static final String JSON_PROPERTY_SID = "sid";
    private String sid;
    public static final String JSON_PROPERTY_TPM_PUBLIC_KEY_HASH = "tpmPublicKeyHash";
    private String tpmPublicKeyHash;
    public static final String JSON_PROPERTY_UDID = "udid";
    private String udid;

    public DeviceProfile diskEncryptionType(DiskEncryptionTypeDef diskEncryptionType) {
        this.diskEncryptionType = diskEncryptionType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="diskEncryptionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DiskEncryptionTypeDef getDiskEncryptionType() {
        return this.diskEncryptionType;
    }

    @JsonProperty(value="diskEncryptionType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDiskEncryptionType(DiskEncryptionTypeDef diskEncryptionType) {
        this.diskEncryptionType = diskEncryptionType;
    }

    public DeviceProfile displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Display name of the device")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DeviceProfile imei(String imei) {
        this.imei = imei;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="International Mobile Equipment Identity (IMEI) of the device")
    @JsonProperty(value="imei")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getImei() {
        return this.imei;
    }

    @JsonProperty(value="imei")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImei(String imei) {
        this.imei = imei;
    }

    public DeviceProfile integrityJailbreak(Boolean integrityJailbreak) {
        this.integrityJailbreak = integrityJailbreak;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the device is jailbroken or rooted. Only applicable to `IOS` and `ANDROID` platforms")
    @JsonProperty(value="integrityJailbreak")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIntegrityJailbreak() {
        return this.integrityJailbreak;
    }

    @JsonProperty(value="integrityJailbreak")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntegrityJailbreak(Boolean integrityJailbreak) {
        this.integrityJailbreak = integrityJailbreak;
    }

    public DeviceProfile manufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the manufacturer of the device")
    @JsonProperty(value="manufacturer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getManufacturer() {
        return this.manufacturer;
    }

    @JsonProperty(value="manufacturer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public DeviceProfile meid(String meid) {
        this.meid = meid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mobile equipment identifier of the device")
    @JsonProperty(value="meid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMeid() {
        return this.meid;
    }

    @JsonProperty(value="meid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMeid(String meid) {
        this.meid = meid;
    }

    public DeviceProfile model(String model) {
        this.model = model;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Model of the device")
    @JsonProperty(value="model")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="model")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModel(String model) {
        this.model = model;
    }

    public DeviceProfile osVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version of the device OS")
    @JsonProperty(value="osVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOsVersion() {
        return this.osVersion;
    }

    @JsonProperty(value="osVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOsVersion(String osVersion) {
        this.osVersion = osVersion;
    }

    public DeviceProfile platform(DevicePlatform platform) {
        this.platform = platform;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public DevicePlatform getPlatform() {
        return this.platform;
    }

    @JsonProperty(value="platform")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPlatform(DevicePlatform platform) {
        this.platform = platform;
    }

    public DeviceProfile registered(Boolean registered) {
        this.registered = registered;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Indicates if the device is registered at Okta")
    @JsonProperty(value="registered")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getRegistered() {
        return this.registered;
    }

    @JsonProperty(value="registered")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRegistered(Boolean registered) {
        this.registered = registered;
    }

    public DeviceProfile secureHardwarePresent(Boolean secureHardwarePresent) {
        this.secureHardwarePresent = secureHardwarePresent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the device contains a secure hardware functionality")
    @JsonProperty(value="secureHardwarePresent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getSecureHardwarePresent() {
        return this.secureHardwarePresent;
    }

    @JsonProperty(value="secureHardwarePresent")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecureHardwarePresent(Boolean secureHardwarePresent) {
        this.secureHardwarePresent = secureHardwarePresent;
    }

    public DeviceProfile serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Serial number of the device")
    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public DeviceProfile sid(String sid) {
        this.sid = sid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Windows Security identifier of the device")
    @JsonProperty(value="sid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSid() {
        return this.sid;
    }

    @JsonProperty(value="sid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSid(String sid) {
        this.sid = sid;
    }

    public DeviceProfile tpmPublicKeyHash(String tpmPublicKeyHash) {
        this.tpmPublicKeyHash = tpmPublicKeyHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Windows Trsted Platform Module hash value")
    @JsonProperty(value="tpmPublicKeyHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTpmPublicKeyHash() {
        return this.tpmPublicKeyHash;
    }

    @JsonProperty(value="tpmPublicKeyHash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTpmPublicKeyHash(String tpmPublicKeyHash) {
        this.tpmPublicKeyHash = tpmPublicKeyHash;
    }

    public DeviceProfile udid(String udid) {
        this.udid = udid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="macOS Unique Device identifier of the device")
    @JsonProperty(value="udid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUdid() {
        return this.udid;
    }

    @JsonProperty(value="udid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUdid(String udid) {
        this.udid = udid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceProfile deviceProfile = (DeviceProfile)o;
        return Objects.equals((Object)this.diskEncryptionType, (Object)deviceProfile.diskEncryptionType) && Objects.equals(this.displayName, deviceProfile.displayName) && Objects.equals(this.imei, deviceProfile.imei) && Objects.equals(this.integrityJailbreak, deviceProfile.integrityJailbreak) && Objects.equals(this.manufacturer, deviceProfile.manufacturer) && Objects.equals(this.meid, deviceProfile.meid) && Objects.equals(this.model, deviceProfile.model) && Objects.equals(this.osVersion, deviceProfile.osVersion) && Objects.equals((Object)this.platform, (Object)deviceProfile.platform) && Objects.equals(this.registered, deviceProfile.registered) && Objects.equals(this.secureHardwarePresent, deviceProfile.secureHardwarePresent) && Objects.equals(this.serialNumber, deviceProfile.serialNumber) && Objects.equals(this.sid, deviceProfile.sid) && Objects.equals(this.tpmPublicKeyHash, deviceProfile.tpmPublicKeyHash) && Objects.equals(this.udid, deviceProfile.udid);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diskEncryptionType, this.displayName, this.imei, this.integrityJailbreak, this.manufacturer, this.meid, this.model, this.osVersion, this.platform, this.registered, this.secureHardwarePresent, this.serialNumber, this.sid, this.tpmPublicKeyHash, this.udid});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceProfile {\n");
        sb.append("    diskEncryptionType: ").append(this.toIndentedString((Object)this.diskEncryptionType)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    imei: ").append(this.toIndentedString(this.imei)).append("\n");
        sb.append("    integrityJailbreak: ").append(this.toIndentedString(this.integrityJailbreak)).append("\n");
        sb.append("    manufacturer: ").append(this.toIndentedString(this.manufacturer)).append("\n");
        sb.append("    meid: ").append(this.toIndentedString(this.meid)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        sb.append("    osVersion: ").append(this.toIndentedString(this.osVersion)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString((Object)this.platform)).append("\n");
        sb.append("    registered: ").append(this.toIndentedString(this.registered)).append("\n");
        sb.append("    secureHardwarePresent: ").append(this.toIndentedString(this.secureHardwarePresent)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    sid: ").append(this.toIndentedString(this.sid)).append("\n");
        sb.append("    tpmPublicKeyHash: ").append(this.toIndentedString(this.tpmPublicKeyHash)).append("\n");
        sb.append("    udid: ").append(this.toIndentedString(this.udid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

