/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.okta.sdk.helper.HelperConstants;
import com.okta.sdk.helper.HelperUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.Pair;
import org.openapitools.client.api.UserFactorApi;
import org.openapitools.client.model.ActivateFactorRequest;
import org.openapitools.client.model.HttpMethod;
import org.openapitools.client.model.UserFactor;

public class UserFactorApiHelper<T extends UserFactor>
extends UserFactorApi {
    public UserFactorApiHelper(UserFactorApi userFactorApi) {
        super(userFactorApi.getApiClient());
    }

    public UserFactorApiHelper(ApiClient apiClient) {
        super(apiClient);
    }

    public <T extends UserFactor> T activateFactorOfType(final Class<T> classType, String userId, String factorId, ActivateFactorRequest activateFactorRequest) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling activateFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling activateFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/lifecycle/activate".replaceAll("\\{userId\\}", apiClient.escapeString(userId)).replaceAll("\\{factorId\\}", apiClient.escapeString(factorId));
        TypeReference localVarReturnType = new TypeReference<T>(){

            public Type getType() {
                return classType;
            }
        };
        return (T)((UserFactor)apiClient.invokeAPI(localVarPath, HttpMethod.POST.name(), new ArrayList<Pair>(), new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), activateFactorRequest, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE), apiClient.selectHeaderContentType(HelperConstants.MEDIA_TYPE), HelperConstants.AUTH_NAMES, localVarReturnType));
    }

    public <T extends UserFactor> T enrollFactorOfType(final Class<T> classType, String userId, UserFactor userFactor, Boolean updatePhone, String templateId, Integer tokenLifetimeSeconds, Boolean activate) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling enrollFactor");
        }
        if (userFactor == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling enrollFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors".replaceAll("\\{userId\\}", apiClient.escapeString(userId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        localVarQueryParams.addAll(apiClient.parameterToPair("updatePhone", updatePhone));
        localVarQueryParams.addAll(apiClient.parameterToPair("templateId", templateId));
        localVarQueryParams.addAll(apiClient.parameterToPair("tokenLifetimeSeconds", tokenLifetimeSeconds));
        localVarQueryParams.addAll(apiClient.parameterToPair("activate", activate));
        TypeReference localVarReturnType = new TypeReference<T>(){

            public Type getType() {
                return classType;
            }
        };
        UserFactor usrFactor = (UserFactor)apiClient.invokeAPI(localVarPath, HttpMethod.POST.name(), localVarQueryParams, new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), userFactor, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE), apiClient.selectHeaderContentType(HelperConstants.MEDIA_TYPE), HelperConstants.AUTH_NAMES, localVarReturnType);
        return (T)((UserFactor)UserFactorApiHelper.getObjectMapper().convertValue((Object)usrFactor, HelperUtil.getUserFactorType(userFactor)));
    }

    public <T extends UserFactor> T resendEnrollFactorOfType(final Class<T> classType, String userId, String factorId, UserFactor userFactor, String templateId) throws ApiException {
        ApiClient apiClient = this.getApiClient();
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling resendEnrollFactor");
        }
        if (factorId == null) {
            throw new ApiException(400, "Missing the required parameter 'factorId' when calling resendEnrollFactor");
        }
        if (userFactor == null) {
            throw new ApiException(400, "Missing the required parameter 'userFactor' when calling resendEnrollFactor");
        }
        String localVarPath = "/api/v1/users/{userId}/factors/{factorId}/resend".replaceAll("\\{userId\\}", apiClient.escapeString(userId)).replaceAll("\\{factorId\\}", apiClient.escapeString(factorId));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>(apiClient.parameterToPair("templateId", templateId));
        TypeReference localVarReturnType = new TypeReference<T>(){

            public Type getType() {
                return classType;
            }
        };
        UserFactor usrFactor = (UserFactor)apiClient.invokeAPI(localVarPath, HttpMethod.POST.name(), localVarQueryParams, new ArrayList<Pair>(), HelperConstants.QUERY_STRING_JOINER.toString(), userFactor, new HashMap<String, String>(), new HashMap<String, String>(), new HashMap<String, Object>(), apiClient.selectHeaderAccept(HelperConstants.MEDIA_TYPE), apiClient.selectHeaderContentType(HelperConstants.MEDIA_TYPE), HelperConstants.AUTH_NAMES, localVarReturnType);
        return (T)((UserFactor)UserFactorApiHelper.getObjectMapper().convertValue((Object)usrFactor, HelperUtil.getUserFactorType(usrFactor)));
    }
}

