/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.LinksSelf;
import org.openapitools.client.model.ProfileMappingSource;
import org.openapitools.client.model.ProfileMappingTarget;

@ApiModel(description="A collection of the profile mappings that include a subset of the profile mapping object's properties. The Profile Mapping object describes a mapping between an Okta User's and an App User's properties using [JSON Schema Draft 4](https://datatracker.ietf.org/doc/html/draft-zyp-json-schema-04).  > **Note:** Same type source/target mappings aren't supported by this API. Profile mappings must either be Okta->App or App->Okta.")
@JsonPropertyOrder(value={"id", "source", "target", "_links"})
public class ListProfileMappings {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_SOURCE = "source";
    private ProfileMappingSource source;
    public static final String JSON_PROPERTY_TARGET = "target";
    private ProfileMappingTarget target;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    @Nullable
    @ApiModelProperty(value="Unique identifier for profile mapping")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public ListProfileMappings source(ProfileMappingSource source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProfileMappingSource getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(ProfileMappingSource source) {
        this.source = source;
    }

    public ListProfileMappings target(ProfileMappingTarget target) {
        this.target = target;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProfileMappingTarget getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTarget(ProfileMappingTarget target) {
        this.target = target;
    }

    public ListProfileMappings links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListProfileMappings listProfileMappings = (ListProfileMappings)o;
        return Objects.equals(this.id, listProfileMappings.id) && Objects.equals(this.source, listProfileMappings.source) && Objects.equals(this.target, listProfileMappings.target) && Objects.equals(this.links, listProfileMappings.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.target, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListProfileMappings {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

