/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.model.DNSRecord;
import org.openapitools.client.model.DomainCertificateMetadata;
import org.openapitools.client.model.DomainCertificateSourceType;
import org.openapitools.client.model.DomainLinks;
import org.openapitools.client.model.DomainValidationStatus;

@ApiModel(description="The properties that define an individual domain.")
@JsonPropertyOrder(value={"brandId", "certificateSourceType", "dnsRecords", "domain", "id", "publicCertificate", "validationStatus", "_links"})
public class DomainResponse {
    public static final String JSON_PROPERTY_BRAND_ID = "brandId";
    private String brandId;
    public static final String JSON_PROPERTY_CERTIFICATE_SOURCE_TYPE = "certificateSourceType";
    private DomainCertificateSourceType certificateSourceType;
    public static final String JSON_PROPERTY_DNS_RECORDS = "dnsRecords";
    private List<DNSRecord> dnsRecords = null;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PUBLIC_CERTIFICATE = "publicCertificate";
    private DomainCertificateMetadata publicCertificate;
    public static final String JSON_PROPERTY_VALIDATION_STATUS = "validationStatus";
    private DomainValidationStatus validationStatus;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private DomainLinks links;

    public DomainResponse brandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="bndul904tTZ6kWVhP0g3", value="The ID number of the brand")
    @JsonProperty(value="brandId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrandId() {
        return this.brandId;
    }

    @JsonProperty(value="brandId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public DomainResponse certificateSourceType(DomainCertificateSourceType certificateSourceType) {
        this.certificateSourceType = certificateSourceType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="certificateSourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DomainCertificateSourceType getCertificateSourceType() {
        return this.certificateSourceType;
    }

    @JsonProperty(value="certificateSourceType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertificateSourceType(DomainCertificateSourceType certificateSourceType) {
        this.certificateSourceType = certificateSourceType;
    }

    public DomainResponse dnsRecords(List<DNSRecord> dnsRecords) {
        this.dnsRecords = dnsRecords;
        return this;
    }

    public DomainResponse addDnsRecordsItem(DNSRecord dnsRecordsItem) {
        if (this.dnsRecords == null) {
            this.dnsRecords = new ArrayList<DNSRecord>();
        }
        this.dnsRecords.add(dnsRecordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="dnsRecords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DNSRecord> getDnsRecords() {
        return this.dnsRecords;
    }

    @JsonProperty(value="dnsRecords")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDnsRecords(List<DNSRecord> dnsRecords) {
        this.dnsRecords = dnsRecords;
    }

    public DomainResponse domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="login.example.com", value="Custom domain name")
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public DomainResponse id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="OcDz6iRyjkaCTXkdo0g3", value="Unique ID of the domain")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public DomainResponse publicCertificate(DomainCertificateMetadata publicCertificate) {
        this.publicCertificate = publicCertificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="publicCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DomainCertificateMetadata getPublicCertificate() {
        return this.publicCertificate;
    }

    @JsonProperty(value="publicCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPublicCertificate(DomainCertificateMetadata publicCertificate) {
        this.publicCertificate = publicCertificate;
    }

    public DomainResponse validationStatus(DomainValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="validationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DomainValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    @JsonProperty(value="validationStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValidationStatus(DomainValidationStatus validationStatus) {
        this.validationStatus = validationStatus;
    }

    public DomainResponse links(DomainLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DomainLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(DomainLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainResponse domainResponse = (DomainResponse)o;
        return Objects.equals(this.brandId, domainResponse.brandId) && Objects.equals((Object)this.certificateSourceType, (Object)domainResponse.certificateSourceType) && Objects.equals(this.dnsRecords, domainResponse.dnsRecords) && Objects.equals(this.domain, domainResponse.domain) && Objects.equals(this.id, domainResponse.id) && Objects.equals(this.publicCertificate, domainResponse.publicCertificate) && Objects.equals((Object)this.validationStatus, (Object)domainResponse.validationStatus) && Objects.equals(this.links, domainResponse.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brandId, this.certificateSourceType, this.dnsRecords, this.domain, this.id, this.publicCertificate, this.validationStatus, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainResponse {\n");
        sb.append("    brandId: ").append(this.toIndentedString(this.brandId)).append("\n");
        sb.append("    certificateSourceType: ").append(this.toIndentedString((Object)this.certificateSourceType)).append("\n");
        sb.append("    dnsRecords: ").append(this.toIndentedString(this.dnsRecords)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    publicCertificate: ").append(this.toIndentedString(this.publicCertificate)).append("\n");
        sb.append("    validationStatus: ").append(this.toIndentedString((Object)this.validationStatus)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

